/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.attachment;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.FileKind;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.utils.attachment.Attachments;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class AttachmentsImpl
extends Attachments {
    Attachment loadInternal(Shell shell, FileKind fileKind, DialogService dialogService, List<ToolboxFileFilter> extensions) throws ToolboxFileFilter.InvalidFilterFilename {
        Optional optionalPath = dialogService.openFileDialog(shell, extensions, Optional.empty());
        if (optionalPath.isPresent()) {
            Path path = (Path)optionalPath.get();
            ToolboxFileFilter.check(extensions, (Path)path);
            byte[] content = null;
            Path pathFilename = path.getFileName();
            content = AttachmentsImpl.getContent((Path)path);
            return new Attachments.AttachmentImpl(pathFilename, fileKind, content);
        }
        return null;
    }

    protected void exportInternal(Shell shell, Attachment attachment, DialogService dialogService, Path exportDir, Consumer<Path> newExportDirConsumer) {
        String dirname;
        DirectoryDialog dialog = new DirectoryDialog(shell);
        if (exportDir != null) {
            dialog.setFilterPath(exportDir.toString());
        }
        if ((dirname = dialog.open()) != null) {
            boolean overwrite2;
            Path path = Paths.get(dirname, attachment.getFullFilename());
            if (path.toFile().exists() && !(overwrite2 = dialogService.confirmOverwrite(shell, path))) {
                return;
            }
            try {
                Throwable overwrite2 = null;
                Object var10_13 = null;
                try (FileOutputStream stream = new FileOutputStream(path.toString());){
                    byte[] data = attachment.getData();
                    stream.write(data);
                    dialogService.openDirectoryAfterExport(shell, path.getParent());
                    newExportDirConsumer.accept(path.getParent());
                }
                catch (Throwable throwable) {
                    if (overwrite2 == null) {
                        overwrite2 = throwable;
                    } else if (overwrite2 != throwable) {
                        overwrite2.addSuppressed(throwable);
                    }
                    throw overwrite2;
                }
            }
            catch (IOException e1) {
                dialogService.error(shell, (Exception)e1);
            }
        }
    }
}

