/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.set.utils.viewgroups.SetViewGroups;

public record TableInfo(Pt1TableCategory category, String shortcut) {
    public TableInfo(String categoryId, String shortcut) {
        this(Pt1TableCategory.getCategoryEnum(categoryId), shortcut);
    }

    public static enum Pt1TableCategory {
        ESTW("estw"),
        ETCS("etcs"),
        ESTW_SUPPLEMENT("supplement-estw");

        private static final Map<String, Pt1TableCategory> categories;
        private final String id;

        static {
            categories = new HashMap<String, Pt1TableCategory>();
            Pt1TableCategory[] pt1TableCategoryArray = Pt1TableCategory.values();
            int n = pt1TableCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Pt1TableCategory category = pt1TableCategoryArray[n2];
                categories.put(category.getId(), category);
                ++n2;
            }
        }

        private Pt1TableCategory(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return switch (this) {
                case ESTW -> SetViewGroups.getTable_ESTW().text();
                case ETCS -> SetViewGroups.getTable_ETCS().text();
                case ESTW_SUPPLEMENT -> SetViewGroups.getTable_ESTW_Supplement().text();
                default -> throw new MatchException(null, null);
            };
        }

        public static Pt1TableCategory getCategoryEnum(String categoryId) {
            return categories.get(categoryId);
        }
    }
}

