/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Lists {
    public static <T> void addAllNew(List<T> list, Collection<T> added) {
        for (T element : added) {
            Lists.addNew(list, element);
        }
    }

    public static <T> void addNew(List<T> list, T element) {
        if (!list.contains(element)) {
            list.add(element);
        }
    }

    public static <T> List<T> filter(List<T> source, Predicate<T> condition) {
        LinkedList<T> result = new LinkedList<T>();
        for (T element : source) {
            if (!condition.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static <F, T> List<T> forEach(List<F> original, Function<F, T> transformation) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (F element : original) {
            result.add(transformation.apply(element));
        }
        return result;
    }

    public static <T> T head(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T last(List<T> list) {
        int index = list.size() - 1;
        if (index >= 0) {
            return list.get(index);
        }
        return null;
    }

    public static <T> List<T> tail(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.subList(1, list.size());
    }

    public static <T> List<T> toList(Collection<T> collection) {
        LinkedList<T> result = new LinkedList<T>();
        result.addAll(collection);
        return result;
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(collection);
        return result;
    }
}

