/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.exceptions;

import java.util.Map;
import javax.xml.transform.TransformerException;

public class XsltServiceException
extends RuntimeException {
    private final Map<String, String> parameters;
    private final ExpandedMessageProvider provider;
    private final String source;
    private final String transformation;

    private static String createMessage(TransformerException e, String transformation, String source, Map<String, String> parameters) {
        return String.format("exception=%s message=%s transformation=%s source=%s parameters=%s", e.getClass().getSimpleName(), e.getMessage(), transformation, source, parameters);
    }

    public XsltServiceException(TransformerException e, String transformation, String source, Map<String, String> parameters, ExpandedMessageProvider provider) {
        super(XsltServiceException.createMessage(e, transformation, source, parameters), e);
        this.transformation = transformation;
        this.source = source;
        this.parameters = parameters;
        this.provider = provider;
    }

    public String getExpandedMessage() {
        return this.provider.getExpandedMessage(this);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getSource() {
        return this.source;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public static interface ExpandedMessageProvider {
        public String getExpandedMessage(XsltServiceException var1);
    }
}

