/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.addons;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.util.StatusPrinter;
import jakarta.annotation.PostConstruct;
import java.io.PrintStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolboxLogAddon {
    private static final String CONSOLE_APPENDER_NAME = "CONSOLE";
    private static final String FILE_APPENDER_NAME = "FILE";
    static final Logger logger = LoggerFactory.getLogger(ToolboxLogAddon.class);

    private static void enableFilelog(String logfile) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusPrinter.print((Context)lc);
        ch.qos.logback.classic.Logger root = lc.getLogger("ROOT");
        ConsoleAppender console = (ConsoleAppender)root.getAppender(CONSOLE_APPENDER_NAME);
        FileAppender fileAppender = new FileAppender();
        fileAppender.setContext((Context)lc);
        fileAppender.setName(FILE_APPENDER_NAME);
        fileAppender.setFile(logfile);
        fileAppender.setEncoder(console.getEncoder());
        fileAppender.start();
        Assert.isTrue((boolean)root.detachAppender(CONSOLE_APPENDER_NAME));
        root.addAppender((Appender)fileAppender);
        StatusPrinter.print((Context)lc);
    }

    @PostConstruct
    private static void postConstruct() {
        String logfile = ToolboxConfiguration.getToolboxLogfile();
        if (logfile != null && !logfile.isEmpty()) {
            ToolboxLogAddon.enableFilelog(logfile);
            ToolboxLogAddon.redirectToLog();
        }
    }

    private static void redirectToLog() {
        logger.info("redirect stdout and stderr to logfile...");
        System.setOut(new PrintStream(System.out){

            @Override
            public void print(String s) {
                logger.info(s);
            }
        });
        System.setErr(new PrintStream(System.err){

            @Override
            public void print(String s) {
                logger.error(s);
            }
        });
        System.out.println("done.");
    }
}

