/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.sirius.business.api.query.SiriusProjectDependencies;
import org.eclipse.sirius.business.internal.query.ProjectDependencyProviderRegistry;

public class SiriusProjectDependencyQuery {
    private IProject project;

    public SiriusProjectDependencyQuery(IProject project) {
        this.project = project;
    }

    public SiriusProjectDependencies getAllDependencies() {
        Optional<SiriusProjectDependencies> dependencies = ProjectDependencyProviderRegistry.getDefault().getProjectDependencyProviders().stream().filter(provider -> provider.canHandle(this.project)).findFirst().map(provider -> provider.getAllDependencies(this.project));
        return dependencies.orElse(null);
    }

    public SiriusProjectDependencies getDirectDependencies() {
        Optional<SiriusProjectDependencies> dependencies = ProjectDependencyProviderRegistry.getDefault().getProjectDependencyProviders().stream().filter(provider -> provider.canHandle(this.project)).findFirst().map(provider -> provider.getDirectDependencies(this.project));
        return dependencies.orElseGet(() -> new SiriusProjectDependencies(new LinkedHashSet<String>(), new LinkedHashSet<String>(), new LinkedHashSet<String>(), new LinkedHashSet<String>()));
    }
}

