/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class HierarchicalPortPositionProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hierarchical port position processing", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        if (layers.size() > 0) {
            this.fixCoordinates(layers.get(0), layeredGraph);
        }
        if (layers.size() > 1) {
            this.fixCoordinates(layers.get(layers.size() - 1), layeredGraph);
        }
        monitor.done();
    }

    private void fixCoordinates(Layer layer, LGraph layeredGraph) {
        PortConstraints portConstraints = (PortConstraints)layeredGraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        if (!portConstraints.isRatioFixed() && !portConstraints.isPosFixed()) {
            return;
        }
        double graphHeight = layeredGraph.getActualSize().y;
        for (LNode node : layer) {
            PortSide extPortSide;
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT || (extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE)) != PortSide.EAST && extPortSide != PortSide.WEST) continue;
            double finalYCoordinate = (Double)node.getProperty(InternalProperties.PORT_RATIO_OR_POSITION);
            if (portConstraints == PortConstraints.FIXED_RATIO) {
                finalYCoordinate *= graphHeight;
            }
            node.getPosition().y = finalYCoordinate - ((KVector)node.getProperty(LayeredOptions.PORT_ANCHOR)).y;
            node.borderToContentAreaCoordinates(false, true);
        }
    }
}

