/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.util;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;

public final class DocumentSymbols {
    public static Iterator<DocumentSymbol> asIterator(DocumentSymbol documentSymbol) {
        return new DocumentSymbolIterator(documentSymbol);
    }

    private DocumentSymbols() {
    }

    protected static abstract class BreadthFirstIterator<T>
    implements Iterator<T> {
        private final Queue<T> queue;

        protected BreadthFirstIterator(T root) {
            Preconditions.checkNotNull(root, "root");
            this.queue = new ArrayDeque<T>();
            this.queue.add(root);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            T result = this.queue.remove();
            Iterable<T> children = this.getChildren(result);
            if (children != null) {
                for (T child : children) {
                    this.queue.add(child);
                }
            }
            return result;
        }

        protected abstract Iterable<T> getChildren(T var1);
    }

    protected static class DocumentSymbolIterator
    extends BreadthFirstIterator<DocumentSymbol> {
        protected DocumentSymbolIterator(DocumentSymbol documentSymbol) {
            super(Preconditions.checkNotNull(documentSymbol, "documentSymbol"));
        }

        @Override
        protected Iterable<DocumentSymbol> getChildren(DocumentSymbol node) {
            return node.getChildren();
        }
    }
}

