/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.actions.PropertyDialogAction;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositorySelectionGroup;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.osgi.framework.Version;

public class EditIUContainerPage
extends WizardPage
implements IEditBundleContainerPage {
    private static final IStatus BAD_IU_SELECTION = Status.error((String)Messages.EditIUContainerPage_0);
    private IStatus fSelectedIUStatus = Status.OK_STATUS;
    private static final String SETTINGS_GROUP_BY_CATEGORY = "groupByCategory";
    private static final String SETTINGS_SHOW_OLD_VERSIONS = "showVersions";
    private static final String SETTINGS_SELECTED_REPOSITORY = "selectedRepository";
    private static final int REFRESH_INTERVAL = 4000;
    private static final int REFRESH_TRIES = 10;
    private static final String EMPTY_VERSION = Version.emptyVersion.toString();
    private static final String LATEST_LABEL = Messages.EditIUContainerPage_Latest_Label;
    private URI fRepoLocation;
    private IUBundleContainer fEditContainer;
    private IUViewQueryContext fQueryContext;
    private final ITargetDefinition fTarget;
    private RepositorySelectionGroup fRepoSelector;
    private AvailableIUGroup fAvailableIUGroup;
    private Map<IInstallableUnit, String> versionSpecifications = new HashMap<IInstallableUnit, String>();
    private Label fSelectionCount;
    private Button fPropertiesButton;
    private IAction fPropertyAction;
    private Button fShowCategoriesButton;
    private Button fShowOldVersionsButton;
    private Button fIncludeRequiredButton;
    private Button fAllPlatformsButton;
    private Button fIncludeSourceButton;
    private Button fConfigurePhaseButton;
    private Button fFollowRepositoryReferencesButton;
    private Text fDetailsText;
    private final ProvisioningUI profileUI;
    private Thread refreshThread;

    protected EditIUContainerPage(ITargetDefinition definition) {
        super("AddP2Container");
        ProvisioningSession session;
        this.setTitle(Messages.EditIUContainerPage_5);
        this.setMessage(Messages.EditIUContainerPage_6);
        this.fTarget = definition;
        try {
            session = new ProvisioningSession(P2TargetUtils.getAgent());
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
            session = ProvisioningUI.getDefaultUI().getSession();
        }
        this.profileUI = new ProvisioningUI(session, P2TargetUtils.getProfileId((ITargetDefinition)definition), new Policy());
    }

    protected EditIUContainerPage(IUBundleContainer container, ITargetDefinition definition) {
        this(definition);
        this.setTitle(Messages.EditIUContainerPage_7);
        this.setMessage(Messages.EditIUContainerPage_6);
        this.fEditContainer = container;
    }

    @Override
    public ITargetLocation getBundleContainer() {
        URI[] uRIArray;
        ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
        if (service == null) {
            PDEPlugin.log(Status.error((String)Messages.EditIUContainerPage_9));
        }
        int flags = this.fIncludeRequiredButton.getSelection() ? 1 : 0;
        flags |= this.fAllPlatformsButton.getSelection() ? 2 : 0;
        flags |= this.fIncludeSourceButton.getSelection() ? 4 : 0;
        flags |= this.fConfigurePhaseButton.getSelection() ? 8 : 0;
        flags |= this.fFollowRepositoryReferencesButton.getSelection() ? 16 : 0;
        IInstallableUnit[] selectedIUs = this.fAvailableIUGroup.getCheckedLeafIUs();
        if (this.fRepoLocation != null) {
            URI[] uRIArray2 = new URI[1];
            uRIArray = uRIArray2;
            uRIArray2[0] = this.fRepoLocation;
        } else {
            uRIArray = null;
        }
        URI[] repos = uRIArray;
        this.versionSpecifications.values().removeIf(String::isBlank);
        if (!this.versionSpecifications.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>(selectedIUs.length);
            ArrayList<String> versions = new ArrayList<String>(selectedIUs.length);
            IInstallableUnit[] iInstallableUnitArray = selectedIUs;
            int n = selectedIUs.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                ids.add(iu.getId());
                String version = this.versionSpecifications.get(iu);
                if (version == null || version.isBlank()) {
                    version = iu.getVersion().toString();
                }
                versions.add(version);
                ++n2;
            }
            return service.newIULocation((String[])ids.toArray(String[]::new), (String[])versions.toArray(String[]::new), repos, flags);
        }
        return service.newIULocation(selectedIUs, repos, flags);
    }

    @Override
    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(SETTINGS_GROUP_BY_CATEGORY, this.fShowCategoriesButton.getSelection());
            settings.put(SETTINGS_SHOW_OLD_VERSIONS, this.fShowOldVersionsButton.getSelection());
            settings.put(SETTINGS_SELECTED_REPOSITORY, this.fRepoLocation != null ? this.fRepoLocation.toString() : null);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        this.createQueryContext();
        this.createRepositoryComboArea(composite);
        this.createAvailableIUArea(composite);
        this.createDetailsArea(composite);
        this.createCheckboxArea(composite);
        this.restoreWidgetState();
        this.setControl((Control)composite);
        this.setPageComplete(false);
        if (this.fEditContainer == null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.location_add_site_wizard");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.location_edit_site_wizard");
        }
    }

    private void createRepositoryComboArea(Composite parent) {
        this.profileUI.getPolicy().setRepositoryPreferencePageId(null);
        this.fRepoSelector = new RepositorySelectionGroup(this.profileUI, this.getContainer(), parent, this.fQueryContext);
        this.fRepoSelector.addRepositorySelectionListener((repoChoice, repoLocation) -> {
            this.fAvailableIUGroup.setRepositoryFilter(repoChoice, repoLocation);
            URI uRI = this.fRepoLocation = repoChoice == 4 ? repoLocation : null;
            if (repoChoice == 2) {
                this.setDescription(Messages.EditIUContainerPage_10);
            } else {
                this.setDescription(Messages.EditIUContainerPage_11);
                this.refreshAvailableIUArea(parent);
            }
            this.pageChanged();
        });
    }

    private void refreshAvailableIUArea(Composite parent) {
        if (this.fEditContainer == null || this.fEditContainer.getInstallableUnits().isEmpty() || this.refreshThread != null && this.refreshThread.isAlive()) {
            return;
        }
        this.refreshThread = new Thread(() -> {
            try {
                AtomicBoolean loaded = new AtomicBoolean(false);
                int tries = 0;
                while (!loaded.get()) {
                    if (10 == tries++) {
                        throw new InterruptedException("reached maximum number of tries");
                    }
                    Thread.sleep(4000L);
                    if (!parent.isDisposed()) {
                        parent.getDisplay().syncExec(() -> {
                            TreeItem[] children = this.fAvailableIUGroup.getCheckboxTreeViewer().getTree().getItems();
                            String pendingLabel = ProgressMessages.PendingUpdateAdapter_PendingLabel;
                            if (children.length > 0 && !children[0].getText().equals(pendingLabel)) {
                                this.fAvailableIUGroup.getCheckboxTreeViewer().expandAll();
                                this.setInstallableUnits(this.fEditContainer);
                                this.fAvailableIUGroup.getCheckboxTreeViewer().collapseAll();
                                loaded.set(true);
                            }
                        });
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                PDEPlugin.log(e);
            }
        });
        this.refreshThread.start();
    }

    private void createAvailableIUArea(Composite parent) {
        int filterConstant = 2;
        if (!this.profileUI.getPolicy().getRepositoriesVisible()) {
            filterConstant = 1;
        }
        this.fAvailableIUGroup = new AvailableIUGroup(this.profileUI, parent, parent.getFont(), this.fQueryContext, null, filterConstant){

            protected StructuredViewer createViewer(Composite parent) {
                final ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)super.createViewer(parent);
                TreeViewerColumn column = new TreeViewerColumn((TreeViewer)treeViewer, 0, this.getColumnConfig().length);
                column.getColumn().setText(Messages.EditIUContainerPage_VersionSpecification_Label);
                column.getColumn().setWidth(150);
                column.getColumn().setResizable(true);
                TextCellEditor versionSpecEditor = new TextCellEditor((Composite)treeViewer.getTree());
                versionSpecEditor.setValidator(this::validateVersionSpecification);
                column.setEditingSupport(new EditingSupport((ColumnViewer)treeViewer, (CellEditor)versionSpecEditor){
                    private final /* synthetic */ CellEditor val$versionSpecEditor;
                    {
                        this.val$versionSpecEditor = cellEditor;
                        super($anonymous0);
                    }

                    protected void setValue(Object element, Object value) {
                        if (element instanceof AvailableIUElement) {
                            AvailableIUElement iuElement = (AvailableIUElement)element;
                            if (value instanceof String) {
                                String spec = (String)value;
                                spec = 1.sanitizeVersionSpecification(spec);
                                (this).EditIUContainerPage.this.versionSpecifications.put(iuElement.getIU(), spec);
                                treeViewer.update((Object)iuElement, null);
                            }
                        }
                    }

                    protected Object getValue(Object element) {
                        return this.getVersionSpecification(element);
                    }

                    protected boolean canEdit(Object element) {
                        AvailableIUElement iuElement;
                        return element instanceof AvailableIUElement && treeViewer.getChecked((Object)(iuElement = (AvailableIUElement)element));
                    }

                    protected CellEditor getCellEditor(Object element) {
                        return this.val$versionSpecEditor;
                    }
                });
                column.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(this::getVersionSpecification));
                return treeViewer;
            }

            private static String sanitizeVersionSpecification(String spec) {
                return LATEST_LABEL.equals(spec = spec.strip()) ? EMPTY_VERSION : spec;
            }

            private String getVersionSpecification(Object e) {
                String string;
                if (e instanceof AvailableIUElement) {
                    AvailableIUElement iu = (AvailableIUElement)e;
                    string = EditIUContainerPage.this.versionSpecifications.getOrDefault(iu.getIU(), "");
                } else {
                    string = "";
                }
                String spec = string;
                return EMPTY_VERSION.equals(spec) ? LATEST_LABEL : spec;
            }

            private String validateVersionSpecification(Object value) {
                if (LATEST_LABEL.equals(value)) {
                    return null;
                }
                IStatus result = VersionUtil.validateVersionRange((String)((String)value));
                return result.isOK() ? null : result.getMessage();
            }
        };
        this.fAvailableIUGroup.getCheckboxTreeViewer().addCheckStateListener(event -> {
            IInstallableUnit[] units = this.fAvailableIUGroup.getCheckedLeafIUs();
            if (units.length > 0) {
                if (units.length == 1) {
                    this.fSelectionCount.setText(NLS.bind((String)Messages.EditIUContainerPage_itemSelected, (Object)Integer.toString(units.length)));
                } else {
                    this.fSelectionCount.setText(NLS.bind((String)Messages.EditIUContainerPage_itemsSelected, (Object)Integer.toString(units.length)));
                }
                this.fSelectedIUStatus = Status.OK_STATUS;
            } else {
                TreeItem[] children = this.fAvailableIUGroup.getCheckboxTreeViewer().getTree().getItems();
                String pendingLabel = ProgressMessages.PendingUpdateAdapter_PendingLabel;
                if (children.length > 0 && !children[0].getText().equals(pendingLabel)) {
                    this.fSelectionCount.setText(NLS.bind((String)Messages.EditIUContainerPage_itemsSelected, (Object)Integer.toString(0)));
                    this.fSelectedIUStatus = BAD_IU_SELECTION;
                }
            }
            this.pageChanged();
        });
        this.fAvailableIUGroup.getCheckboxTreeViewer().addSelectionChangedListener(event -> {
            this.updateDetails();
            this.fPropertiesButton.setEnabled(this.fAvailableIUGroup.getSelectedIUElements().length == 1);
        });
        this.fAvailableIUGroup.setUseBoldFontForFilteredItems(true);
        GridData data = (GridData)this.fAvailableIUGroup.getStructuredViewer().getControl().getLayoutData();
        data.heightHint = 200;
        Composite buttonParent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 10;
        buttonParent.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, -1, true, false);
        buttonParent.setLayoutData((Object)gridData);
        Button selectAll = new Button(buttonParent, 8);
        selectAll.setText(ProvUIMessages.SelectableIUsPage_Select_All);
        selectAll.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(selectAll);
        selectAll.addListener(13, event -> this.setAllChecked(true));
        Button deselectAll = new Button(buttonParent, 8);
        deselectAll.setText(ProvUIMessages.SelectableIUsPage_Deselect_All);
        deselectAll.setLayoutData((Object)new GridData());
        SWTFactory.setButtonDimensionHint(deselectAll);
        deselectAll.addListener(13, event -> this.setAllChecked(false));
        this.fSelectionCount = SWTFactory.createLabel(buttonParent, NLS.bind((String)Messages.EditIUContainerPage_itemsSelected, (Object)Integer.toString(0)), 1);
        GridData labelData = new GridData();
        labelData.widthHint = 200;
        this.fSelectionCount.setLayoutData((Object)labelData);
    }

    private void setAllChecked(boolean checked) {
        if (checked) {
            TreeItem[] items = this.fAvailableIUGroup.getCheckboxTreeViewer().getTree().getItems();
            this.checkAll(checked, items);
            this.fAvailableIUGroup.setChecked(this.fAvailableIUGroup.getCheckboxTreeViewer().getCheckedElements());
        } else {
            this.fAvailableIUGroup.setChecked(new Object[0]);
        }
        this.updateSelection();
    }

    private void checkAll(boolean checked, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setChecked(checked);
            TreeItem[] children = item.getItems();
            this.checkAll(checked, children);
            ++n2;
        }
    }

    private void updateSelection() {
        int count = this.fAvailableIUGroup.getCheckedLeafIUs().length;
        this.setPageComplete(count > 0);
        if (count == 0) {
            String message = ProvUIMessages.AvailableIUsPage_MultipleSelectionCount;
            this.fSelectionCount.setText(NLS.bind((String)message, (Object)Integer.toString(count)));
        } else {
            String message = count == 1 ? ProvUIMessages.AvailableIUsPage_SingleSelectionCount : ProvUIMessages.AvailableIUsPage_MultipleSelectionCount;
            this.fSelectionCount.setText(NLS.bind((String)message, (Object)Integer.toString(count)));
        }
    }

    private void createDetailsArea(Composite parent) {
        Group detailsGroup = SWTFactory.createGroup(parent, Messages.EditIUContainerPage_12, 1, 1, 768);
        this.fDetailsText = SWTFactory.createText((Composite)detailsGroup, 72, 1, 768);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 50;
        gd.widthHint = 400;
        this.fDetailsText.setLayoutData((Object)gd);
        this.fPropertiesButton = SWTFactory.createPushButton((Composite)detailsGroup, Messages.EditIUContainerPage_13, null);
        ((GridData)this.fPropertiesButton.getLayoutData()).horizontalAlignment = 131072;
        this.fPropertiesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.fPropertyAction.run()));
        this.fPropertyAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this.fAvailableIUGroup.getStructuredViewer());
        this.fPropertiesButton.setEnabled(false);
    }

    private void createCheckboxArea(Composite parent) {
        Composite checkComp = SWTFactory.createComposite(parent, 2, 1, 768, 0, 0);
        checkComp.setLayout((Layout)new GridLayout(2, true));
        this.fShowCategoriesButton = SWTFactory.createCheckButton(checkComp, Messages.EditIUContainerPage_14, null, true, 1);
        this.fShowCategoriesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateViewContext()));
        this.fShowOldVersionsButton = SWTFactory.createCheckButton(checkComp, Messages.EditIUContainerPage_15, null, true, 1);
        this.fShowOldVersionsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateViewContext()));
        Group slicerGroup = SWTFactory.createGroup(parent, Messages.EditIUContainerPage_1, 1, 1, 768);
        SWTFactory.createWrapLabel((Composite)slicerGroup, Messages.EditIUContainerPage_2, 1, 400);
        this.fIncludeRequiredButton = SWTFactory.createCheckButton((Composite)slicerGroup, Messages.EditIUContainerPage_3, null, true, 1);
        this.fIncludeRequiredButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fAllPlatformsButton.setEnabled(!this.fIncludeRequiredButton.getSelection());
            this.warnIfGlobalSettingChanged();
        }));
        this.fAllPlatformsButton = SWTFactory.createCheckButton((Composite)slicerGroup, Messages.EditIUContainerPage_8, null, false, 1);
        this.fAllPlatformsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.warnIfGlobalSettingChanged()));
        ((GridData)this.fAllPlatformsButton.getLayoutData()).horizontalIndent = 10;
        this.fIncludeSourceButton = SWTFactory.createCheckButton((Composite)slicerGroup, Messages.EditIUContainerPage_16, null, true, 1);
        this.fIncludeSourceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.warnIfGlobalSettingChanged()));
        this.fConfigurePhaseButton = SWTFactory.createCheckButton((Composite)slicerGroup, Messages.EditIUContainerPage_IncludeConfigurePhase, null, true, 1);
        this.fConfigurePhaseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.warnIfGlobalSettingChanged()));
        this.fFollowRepositoryReferencesButton = SWTFactory.createCheckButton((Composite)slicerGroup, Messages.EditIUContainerPage_17, null, true, 1);
        this.fFollowRepositoryReferencesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.warnIfGlobalSettingChanged()));
    }

    private void warnIfGlobalSettingChanged() {
        boolean noChange = true;
        ITargetLocation[] containers = this.fTarget.getTargetLocations();
        if (containers != null) {
            IUBundleContainer iuContainer = Arrays.stream(containers).filter(container -> container != this.fEditContainer).filter(IUBundleContainer.class::isInstance).map(IUBundleContainer.class::cast).findFirst().orElse(null);
            if (iuContainer != null) {
                noChange &= this.fIncludeRequiredButton.getSelection() == iuContainer.getIncludeAllRequired();
                noChange &= this.fAllPlatformsButton.getSelection() == iuContainer.getIncludeAllEnvironments();
                noChange &= this.fIncludeSourceButton.getSelection() == iuContainer.getIncludeSource();
                noChange &= this.fConfigurePhaseButton.getSelection() == iuContainer.getIncludeConfigurePhase();
                noChange &= this.fFollowRepositoryReferencesButton.getSelection() == iuContainer.isFollowRepositoryReferences();
            }
        }
        if (noChange) {
            this.setMessage(Messages.EditIUContainerPage_6);
        } else {
            this.setMessage(Messages.EditIUContainerPage_4, 2);
        }
    }

    private void createQueryContext() {
        this.fQueryContext = ProvUI.getQueryContext((Policy)this.profileUI.getPolicy());
        this.fQueryContext.setInstalledProfileId(P2TargetUtils.getProfileId((ITargetDefinition)this.fTarget));
        this.fQueryContext.setHideAlreadyInstalled(false);
    }

    private void updateViewContext() {
        if (this.fShowCategoriesButton.getSelection()) {
            this.fQueryContext.setViewType(1);
        } else {
            this.fQueryContext.setViewType(3);
        }
        this.fQueryContext.setShowLatestVersionsOnly(this.fShowOldVersionsButton.getSelection());
        this.fAvailableIUGroup.updateAvailableViewState();
        this.fAvailableIUGroup.getStructuredViewer().refresh();
    }

    private void updateDetails() {
        IInstallableUnit[] selected = this.fAvailableIUGroup.getSelectedIUs().toArray(new IInstallableUnit[0]);
        if (selected.length == 1) {
            StringBuilder result = new StringBuilder();
            String description = selected[0].getProperty("org.eclipse.equinox.p2.description", null);
            if (description != null) {
                result.append(description);
            } else {
                String name = selected[0].getProperty("org.eclipse.equinox.p2.name", null);
                if (name != null) {
                    result.append(name);
                } else {
                    result.append(selected[0].getId());
                }
                result.append(" ");
                result.append(selected[0].getVersion().toString());
            }
            this.fDetailsText.setText(result.toString());
            return;
        }
        this.fDetailsText.setText("");
    }

    void pageChanged() {
        if (this.fSelectedIUStatus.getSeverity() == 4) {
            this.setErrorMessage(this.fSelectedIUStatus.getMessage());
            this.setPageComplete(false);
        } else if (this.fAvailableIUGroup != null && this.fAvailableIUGroup.getCheckedLeafIUs().length == 0) {
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private void restoreWidgetState() {
        ITargetLocation[] containers;
        IUBundleContainer iuContainer;
        int n;
        int n2;
        ITargetLocation[] iTargetLocationArray;
        String stringURI;
        IDialogSettings settings = this.getDialogSettings();
        URI uri = null;
        boolean showCategories = this.fQueryContext.shouldGroupByCategories();
        boolean showOldVersions = this.fQueryContext.getShowLatestVersionsOnly();
        if (this.fEditContainer != null) {
            List repositories = this.fEditContainer.getRepositories();
            if (!repositories.isEmpty()) {
                uri = (URI)repositories.get(0);
            }
        } else if (settings != null && (stringURI = settings.get(SETTINGS_SELECTED_REPOSITORY)) != null && stringURI.trim().length() > 0) {
            try {
                uri = new URI(stringURI);
            }
            catch (URISyntaxException e) {
                PDEPlugin.log(e);
            }
        }
        if (settings != null) {
            if (settings.get(SETTINGS_GROUP_BY_CATEGORY) != null) {
                showCategories = settings.getBoolean(SETTINGS_GROUP_BY_CATEGORY);
            }
            if (settings.get(SETTINGS_SHOW_OLD_VERSIONS) != null) {
                showOldVersions = settings.getBoolean(SETTINGS_SHOW_OLD_VERSIONS);
            }
        }
        if (uri != null) {
            this.fRepoSelector.setRepositorySelection(4, uri);
        } else if (this.fEditContainer != null) {
            this.fRepoSelector.setRepositorySelection(1, null);
        } else {
            this.fRepoSelector.setRepositorySelection(2, null);
        }
        this.fShowCategoriesButton.setSelection(showCategories);
        this.fShowOldVersionsButton.setSelection(showOldVersions);
        if (this.fEditContainer != null) {
            this.fIncludeRequiredButton.setSelection(this.fEditContainer.getIncludeAllRequired());
            this.fAllPlatformsButton.setSelection(this.fEditContainer.getIncludeAllEnvironments());
            this.fIncludeSourceButton.setSelection(this.fEditContainer.getIncludeSource());
            this.fConfigurePhaseButton.setSelection(this.fEditContainer.getIncludeConfigurePhase());
            this.fFollowRepositoryReferencesButton.setSelection(this.fEditContainer.isFollowRepositoryReferences());
        } else {
            ITargetLocation[] knownContainers = this.fTarget.getTargetLocations();
            if (knownContainers != null) {
                iTargetLocationArray = knownContainers;
                n2 = knownContainers.length;
                n = 0;
                while (n < n2) {
                    ITargetLocation knownContainer = iTargetLocationArray[n];
                    if (knownContainer instanceof IUBundleContainer) {
                        iuContainer = (IUBundleContainer)knownContainer;
                        this.fIncludeRequiredButton.setSelection(iuContainer.getIncludeAllRequired());
                        this.fAllPlatformsButton.setSelection(iuContainer.getIncludeAllEnvironments());
                        this.fIncludeSourceButton.setSelection(iuContainer.getIncludeSource());
                        this.fConfigurePhaseButton.setSelection(iuContainer.getIncludeConfigurePhase());
                        this.fFollowRepositoryReferencesButton.setSelection(iuContainer.isFollowRepositoryReferences());
                    }
                    ++n;
                }
            }
        }
        if (this.fTarget != null && (containers = this.fTarget.getTargetLocations()) != null) {
            iTargetLocationArray = containers;
            n2 = containers.length;
            n = 0;
            while (n < n2) {
                ITargetLocation container = iTargetLocationArray[n];
                if (container instanceof IUBundleContainer && (iuContainer = (IUBundleContainer)container) != this.fEditContainer) {
                    this.fIncludeRequiredButton.setSelection(iuContainer.getIncludeAllRequired());
                    this.fAllPlatformsButton.setSelection(iuContainer.getIncludeAllEnvironments());
                    break;
                }
                ++n;
            }
        }
        this.fAllPlatformsButton.setEnabled(!this.fIncludeRequiredButton.getSelection());
        this.updateViewContext();
        this.fRepoSelector.getDefaultFocusControl().setFocus();
        this.updateDetails();
        if (this.fEditContainer != null) {
            this.fQueryContext.setViewType(3);
            this.fAvailableIUGroup.updateAvailableViewState();
            this.setInstallableUnits(this.fEditContainer);
            this.updateViewContext();
            IInstallableUnit[] units = this.fAvailableIUGroup.getCheckedLeafIUs();
            if (units.length > 0) {
                this.fAvailableIUGroup.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection((Object)units[0]), true);
            }
            String msg = units.length == 1 ? Messages.EditIUContainerPage_itemSelected : Messages.EditIUContainerPage_itemsSelected;
            this.fSelectionCount.setText(NLS.bind((String)msg, (Object)units.length));
            this.fAvailableIUGroup.getCheckboxTreeViewer().collapseAll();
        }
    }

    private void setInstallableUnits(IUBundleContainer iuContainer) {
        this.versionSpecifications = new HashMap<IInstallableUnit, String>(iuContainer.getInstallableUnitSpecifications());
        this.fAvailableIUGroup.setChecked(this.versionSpecifications.keySet().toArray());
    }
}

