/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.json.core.internal.schema.catalog.UserEntries;
import org.eclipse.wst.json.core.internal.schema.catalog.UserEntry;
import org.eclipse.wst.json.ui.internal.JSONUIMessages;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;

public class EntryDialog
extends TitleAreaDialog {
    private Image dlgTitleImage;
    private UserEntry selectedEntry;
    private String fileMatch;
    private URI url;
    private Text fileMatchText;
    private Text urlText;
    private Button okButton;
    private UserEntries entries;

    protected EntryDialog(Shell parentShell, UserEntry entry, UserEntries entries) {
        super(parentShell);
        this.selectedEntry = entry;
        this.entries = entries;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.selectedEntry == null) {
            this.setTitle(JSONUIMessages.Add_Catalog_Entry);
            this.setMessage(JSONUIMessages.Add_Catalog_Entry);
        } else {
            this.setTitle(JSONUIMessages.Edit_Catalog_Entry);
            this.setMessage(JSONUIMessages.Edit_Catalog_Entry);
        }
        ImageDescriptor descriptor = JSONUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.json.ui", (String)"icons/WizBan.png");
        if (descriptor != null) {
            this.dlgTitleImage = descriptor.createImage();
            this.setTitleImage(this.dlgTitleImage);
        }
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(parentComposite, 4);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(JSONUIMessages.FileMatch);
        this.fileMatchText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileMatchText.setLayoutData((Object)gd);
        this.fileMatchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryDialog.this.validatePage();
            }
        });
        Label urlLabel = new Label(container, 0);
        urlLabel.setText(JSONUIMessages.URL);
        this.urlText = new Text(container, 2052);
        gd = new GridData(768);
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryDialog.this.validatePage();
            }
        });
        if (this.selectedEntry != null) {
            this.urlText.setText(this.selectedEntry.getUrl().toString());
            this.fileMatchText.setText(this.selectedEntry.getFileMatch());
        }
        Button browse = new Button(container, 8);
        browse.setText(JSONUIMessages.Browse);
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EntryDialog.this.getShell(), 4);
                String result = dialog.open();
                if (result == null || result.trim().length() == 0) {
                    return;
                }
                try {
                    String urlString = new File(result).toURI().toURL().toString();
                    EntryDialog.this.urlText.setText(urlString);
                }
                catch (MalformedURLException malformedURLException) {
                    EntryDialog.this.urlText.setText("file:///" + result);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parentComposite;
    }

    private boolean validatePage() {
        this.fileMatch = null;
        this.url = null;
        if (this.fileMatchText.getText().trim().length() <= 0) {
            this.setErrorMessage(JSONUIMessages.The_name_field_is_required);
            return this.updateButton(false);
        }
        Set list = this.entries.getEntries();
        for (UserEntry entry : list) {
            if (entry == this.selectedEntry || !this.fileMatchText.getText().equals(entry.getFileMatch())) continue;
            this.setErrorMessage(JSONUIMessages.The_entry_already_exists);
            return this.updateButton(false);
        }
        if (this.urlText.getText().trim().length() <= 0) {
            this.setErrorMessage(JSONUIMessages.The_url_field_is_required);
            return this.updateButton(false);
        }
        try {
            new URL(this.urlText.getText());
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(JSONUIMessages.Invalid_URL);
            return this.updateButton(false);
        }
        this.setErrorMessage(null);
        this.fileMatch = this.fileMatchText.getText();
        try {
            this.url = new URL(this.urlText.getText()).toURI();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return this.updateButton(true);
    }

    private boolean updateButton(boolean enabled) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enabled);
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(this.selectedEntry != null);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public String getFileMatch() {
        return this.fileMatch;
    }

    public URI getURL() {
        return this.url;
    }
}

