/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdi.internal.ClassObjectReferenceImpl;
import org.eclipse.jdi.internal.ClassTypeImpl;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ReferenceTypeImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.jdwp.JdwpClassObjectID;
import org.eclipse.jdi.internal.jdwp.JdwpInterfaceID;

public class InterfaceTypeImpl
extends ReferenceTypeImpl
implements InterfaceType {
    public static final byte typeTag = 2;

    public InterfaceTypeImpl(VirtualMachineImpl vmImpl, JdwpInterfaceID interfaceID) {
        super("InterfaceType", vmImpl, interfaceID);
    }

    public InterfaceTypeImpl(VirtualMachineImpl vmImpl, JdwpInterfaceID interfaceID, String signature, String genericSignature) {
        super("InterfaceType", vmImpl, interfaceID, signature, genericSignature);
    }

    @Override
    public Value createNullValue() {
        return new ClassObjectReferenceImpl(this.virtualMachineImpl(), new JdwpClassObjectID(this.virtualMachineImpl()));
    }

    @Override
    public byte typeTag() {
        return 2;
    }

    @Override
    public void flushStoredJdwpResults() {
        super.flushStoredJdwpResults();
        Iterator<Object> itr = this.virtualMachineImpl().allCachedRefTypes();
        while (itr.hasNext()) {
            ReferenceTypeImpl refType = (ReferenceTypeImpl)itr.next();
            if (refType.fInterfaces == null || !refType.fInterfaces.contains(this)) continue;
            refType.flushStoredJdwpResults();
        }
    }

    @Override
    public List<ClassType> implementors() {
        ArrayList<ClassType> implementors = new ArrayList<ClassType>();
        Iterator<ReferenceType> itr = this.virtualMachineImpl().allRefTypes();
        while (itr.hasNext()) {
            ReferenceType refType = itr.next();
            if (!(refType instanceof ClassTypeImpl)) continue;
            try {
                ClassTypeImpl classType = (ClassTypeImpl)refType;
                List<InterfaceType> interfaces = classType.interfaces();
                if (!interfaces.contains(this)) continue;
                implementors.add(classType);
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                // empty catch block
            }
        }
        return implementors;
    }

    @Override
    public List<InterfaceType> subinterfaces() {
        ArrayList<InterfaceType> implementors = new ArrayList<InterfaceType>();
        Iterator<ReferenceType> itr = this.virtualMachineImpl().allRefTypes();
        while (itr.hasNext()) {
            try {
                InterfaceTypeImpl interFaceType;
                List<InterfaceType> interfaces;
                ReferenceType refType = itr.next();
                if (!(refType instanceof InterfaceTypeImpl) || !(interfaces = (interFaceType = (InterfaceTypeImpl)refType).superinterfaces()).contains(this)) continue;
                implementors.add(interFaceType);
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                // empty catch block
            }
        }
        return implementors;
    }

    @Override
    public List<InterfaceType> superinterfaces() {
        return this.interfaces();
    }

    @Override
    public Value invokeMethod(ThreadReference thread, Method method, List<? extends Value> arguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        return this.invokeMethod(thread, method, arguments, options, 1281);
    }

    public Method concreteMethodByName(String name, String signature) {
        for (Method method : this.methods()) {
            if (!method.name().equals(name) || !method.signature().equals(signature)) continue;
            if (method.isAbstract()) {
                return null;
            }
            return method;
        }
        if (this.superinterfaces() != null) {
            for (InterfaceType superi : this.superinterfaces()) {
                Method foundMethod = ((InterfaceTypeImpl)superi).concreteMethodByName(name, signature);
                if (foundMethod == null) continue;
                return foundMethod;
            }
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.isPrepared();
    }

    public static InterfaceTypeImpl read(MirrorImpl target, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        JdwpInterfaceID ID = new JdwpInterfaceID(vmImpl);
        ID.read(in);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("interfaceType", ID.value());
        }
        if (ID.isNull()) {
            return null;
        }
        InterfaceTypeImpl mirror = (InterfaceTypeImpl)vmImpl.getCachedMirror(ID);
        if (mirror == null) {
            mirror = new InterfaceTypeImpl(vmImpl, ID);
            vmImpl.addCachedMirror(mirror);
        }
        return mirror;
    }

    public static InterfaceTypeImpl readWithSignature(MirrorImpl target, boolean withGenericSignature, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        JdwpInterfaceID ID = new JdwpInterfaceID(vmImpl);
        ID.read(in);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("interfaceType", ID.value());
        }
        String signature = target.readString("signature", in);
        String genericSignature = null;
        if (withGenericSignature) {
            genericSignature = target.readString("generic signature", in);
        }
        if (ID.isNull()) {
            return null;
        }
        InterfaceTypeImpl mirror = (InterfaceTypeImpl)vmImpl.getCachedMirror(ID);
        if (mirror == null) {
            mirror = new InterfaceTypeImpl(vmImpl, ID);
            vmImpl.addCachedMirror(mirror);
        }
        mirror.setSignature(signature);
        mirror.setGenericSignature(genericSignature);
        return mirror;
    }
}

