/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class RedundantModifiersCleanUp
extends AbstractMultiFix {
    public RedundantModifiersCleanUp() {
        this(Collections.emptyMap());
    }

    public RedundantModifiersCleanUp(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.remove_redundant_modifiers");
        Map<String, String> requiredOptions = null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.remove_redundant_modifiers")) {
            return new String[]{MultiFixMessages.RedundantModifiersCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        if (this.isEnabled("cleanup.remove_redundant_modifiers")) {
            buf.append("public interface IFoo {\n");
            buf.append("  int MAGIC_NUMBER = 646;\n");
            buf.append("  int foo ();\n");
            buf.append("  int bar (int bazz);\n");
        } else {
            buf.append("public abstract interface IFoo {\n");
            buf.append("  public static final int MAGIC_NUMBER = 646;\n");
            buf.append("  public abstract int foo ();\n");
            buf.append("  public int bar (int bazz);\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("public final class Sealed {\n");
        if (this.isEnabled("cleanup.remove_redundant_modifiers")) {
            buf.append("  public void foo () {};\n");
            buf.append("  \n");
            buf.append("  interface INested {\n");
            buf.append("  }\n");
        } else {
            buf.append("  public final void foo () {};\n");
            buf.append("  \n");
            buf.append("  abstract static interface INested {\n");
            buf.append("  }\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("public enum SampleEnum {\n");
        buf.append("  VALUE1(\"1\"), VALUE2(\"2\");\n");
        buf.append("\n");
        if (this.isEnabled("cleanup.remove_redundant_modifiers")) {
            buf.append("  SampleEnum(String string) {}\n");
        } else {
            buf.append("  private SampleEnum(String string) {}\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.remove_redundant_modifiers")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                TypeDeclaration typeDecl;
                TypeDeclaration typeDeclaration = typeDecl = node.getParent() instanceof TypeDeclaration ? (TypeDeclaration)node.getParent() : null;
                if (typeDecl != null && typeDecl.isInterface()) {
                    int excluded = 25;
                    if ((node.getModifiers() & 0x19) > 0) {
                        rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 25));
                    }
                }
                return true;
            }

            public boolean visit(MethodDeclaration node) {
                if (node.getParent() instanceof TypeDeclaration) {
                    TypeDeclaration typeDecl = (TypeDeclaration)node.getParent();
                    if (typeDecl.isInterface()) {
                        if (Modifier.isAbstract((int)node.getModifiers())) {
                            rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 1024));
                        }
                        if (Modifier.isPublic((int)node.getModifiers()) && !AnonymousClassDeclaration.class.isInstance(node.getParent())) {
                            rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 1));
                        }
                    } else if (Modifier.isFinal((int)typeDecl.getModifiers()) && Modifier.isFinal((int)node.getModifiers()) && !node.isVarargs()) {
                        rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 16));
                    }
                } else if (node.getParent() instanceof EnumDeclaration && node.isConstructor() && Modifier.isPrivate((int)node.getModifiers())) {
                    rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 2));
                }
                return true;
            }

            public boolean visit(TypeDeclaration node) {
                if (node.isInterface()) {
                    TypeDeclaration typeDecl;
                    if (Modifier.isAbstract((int)node.getModifiers())) {
                        rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 1024));
                    }
                    if ((typeDecl = ASTNodes.getParent((ASTNode)node, TypeDeclaration.class)) != null && Modifier.isStatic((int)node.getModifiers())) {
                        rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 8));
                    }
                }
                return true;
            }

            public boolean visit(EnumDeclaration node) {
                TypeDeclaration typeDecl;
                TypeDeclaration typeDeclaration = typeDecl = node.getParent() instanceof TypeDeclaration ? (TypeDeclaration)node.getParent() : null;
                if (typeDecl != null && Modifier.isStatic((int)node.getModifiers())) {
                    rewriteOperations.add(new RemoveModifiersOperation((ASTNode)node, 8));
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.RedundantModifiersCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[rewriteOperations.size()]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class RemoveModifiersOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final ASTNode node;
        private final int excludedModifiers;

        public RemoveModifiersOperation(ASTNode node, int excludedModifiers) {
            this.node = node;
            this.excludedModifiers = excludedModifiers;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ModifierRewrite rewrite = ModifierRewrite.create(cuRewrite.getASTRewrite(), this.node);
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.RedundantModifiersCleanup_description, cuRewrite);
            rewrite.setModifiers(0, this.excludedModifiers, group);
        }
    }
}

