/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.manager;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreComparator;
import org.eclipse.scout.sdk.core.s.nls.manager.IStackedTranslation;
import org.eclipse.scout.sdk.core.util.Ensure;

public class StackedTranslation
extends Translation
implements IStackedTranslation {
    private final Map<ITranslationStore, ITranslationEntry> m_entries;
    private Map<Language, String> m_mergedTexts;
    private Map<Language, ITranslationEntry> m_entriesByLanguage;

    protected StackedTranslation(SequencedCollection<ITranslationEntry> entries) {
        super(entries.getFirst().key());
        this.m_entries = entries.stream().collect(Collectors.toMap(ITranslationEntry::store, Function.identity(), Ensure::failOnDuplicates));
    }

    @Override
    protected Map<Language, String> textsMap() {
        if (this.m_mergedTexts == null) {
            this.buildCaches();
        }
        return this.m_mergedTexts;
    }

    protected Map<Language, ITranslationEntry> entriesByLanguage() {
        if (this.m_entriesByLanguage == null) {
            this.buildCaches();
        }
        return this.m_entriesByLanguage;
    }

    protected void buildCaches() {
        HashMap<Language, String> textsMap = new HashMap<Language, String>();
        HashMap<Language, ITranslationEntry> entryMap = new HashMap<Language, ITranslationEntry>();
        this.m_entries.values().stream().sorted(Comparator.comparing(ITranslationEntry::store, TranslationStoreComparator.INSTANCE).reversed()).forEach(entry -> StackedTranslation.cacheEntry(entry, textsMap, entryMap));
        this.m_mergedTexts = textsMap;
        this.m_entriesByLanguage = entryMap;
    }

    protected static void cacheEntry(ITranslationEntry entry, Map<Language, String> textsByLang, Map<Language, ITranslationEntry> entriesByLang) {
        Map<Language, String> textsOfEntry = entry.texts();
        textsByLang.putAll(textsOfEntry);
        textsOfEntry.keySet().forEach(lang -> entriesByLang.put((Language)lang, entry));
    }

    @Override
    public boolean isOverriding(Language language, ITranslationStore store) {
        if (language == null || store == null) {
            return false;
        }
        if (!store.containsLanguage(language)) {
            return false;
        }
        double order = store.service().order();
        return this.m_entries.keySet().stream().anyMatch(s -> s.service().order() > order);
    }

    @Override
    public Stream<Language> languagesOfAllStores() {
        return this.stores().flatMap(ITranslationStore::languages).distinct();
    }

    @Override
    public boolean hasEditableStores() {
        return this.stores().anyMatch(ITranslationStore::isEditable);
    }

    @Override
    public boolean hasOnlyEditableStores() {
        return this.stores().allMatch(ITranslationStore::isEditable);
    }

    @Override
    public Stream<ITranslationStore> stores() {
        return this.m_entries.keySet().stream();
    }

    @Override
    public Optional<ITranslationStore> primaryEditableStore() {
        return this.stores().filter(ITranslationStore::isEditable).min(TranslationStoreComparator.INSTANCE);
    }

    @Override
    public Optional<ITranslationEntry> entry(Language language) {
        return Optional.ofNullable(this.entriesByLanguage().get(language));
    }

    protected void entryAdded(ITranslationEntry newEntry) {
        this.ensureHasSameKey(newEntry);
        this.m_entries.put(newEntry.store(), newEntry);
        this.m_mergedTexts = null;
        this.m_entriesByLanguage = null;
    }

    protected void entryUpdated(ITranslationEntry updatedEntry) {
        this.ensureHasSameKey(updatedEntry);
        this.m_entries.put(updatedEntry.store(), updatedEntry);
        this.m_mergedTexts = null;
        this.m_entriesByLanguage = null;
    }

    protected void ensureHasSameKey(ITranslation t) {
        Ensure.isTrue((boolean)this.key().equals(t.key()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StackedTranslation that = (StackedTranslation)o;
        return this.m_entries.equals(that.m_entries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.m_entries);
    }
}

