/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.manager;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.IEditableTranslationStore;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationImportInfo;
import org.eclipse.scout.sdk.core.s.nls.ITranslationManagerListener;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TextProviderService;
import org.eclipse.scout.sdk.core.s.nls.Translation;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreComparator;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;
import org.eclipse.scout.sdk.core.s.nls.Translations;
import org.eclipse.scout.sdk.core.s.nls.manager.IStackedTranslation;
import org.eclipse.scout.sdk.core.s.nls.manager.StackedTranslation;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationImporter;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManagerEvent;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.EventListenerList;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class TranslationManager {
    private final List<ITranslationStore> m_stores = new ArrayList<ITranslationStore>();
    private final Map<String, StackedTranslation> m_translations;
    private final Path m_modulePath;
    private final Translations.DependencyScope[] m_dependencyScopes;
    private final EventListenerList m_listeners;
    private final List<TranslationManagerEvent> m_eventBuffer;
    private int m_changing;

    protected TranslationManager(Stream<ITranslationStore> stores) {
        this(null, stores, new Translations.DependencyScope[0]);
    }

    protected TranslationManager(Path modulePath, Stream<ITranslationStore> stores, Translations.DependencyScope ... scopes) {
        this.m_stores.addAll(TranslationManager.sortStores(stores));
        this.m_translations = TranslationManager.buildStackedTranslations(this.m_stores.stream());
        this.m_listeners = new EventListenerList();
        this.m_eventBuffer = new ArrayList<TranslationManagerEvent>();
        this.m_modulePath = modulePath;
        this.m_dependencyScopes = scopes == null || scopes.length < 1 ? new Translations.DependencyScope[0] : (Translations.DependencyScope[])Arrays.stream(scopes).filter(Objects::nonNull).toArray(Translations.DependencyScope[]::new);
        Translations.storesHavingImplicitOverrides(this.m_stores).forEach(TranslationManager::logImplicitOverrides);
    }

    public static Optional<TranslationManager> create(Path modulePath, Stream<ITranslationStore> stores, Translations.DependencyScope ... scopes) {
        return Optional.of(new TranslationManager(modulePath, stores, scopes)).filter(manager -> manager.allStores().findAny().isPresent());
    }

    protected static List<ITranslationStore> sortStores(Stream<ITranslationStore> stores) {
        return stores.sorted(TranslationStoreComparator.INSTANCE).collect(Collectors.toList());
    }

    protected static Map<String, StackedTranslation> buildStackedTranslations(Stream<ITranslationStore> stores) {
        return stores.flatMap(ITranslationStore::entries).collect(Collectors.groupingBy(ITranslation::key, Collector.of(ArrayList::new, List::add, TranslationManager::combine, StackedTranslation::new, Collector.Characteristics.UNORDERED)));
    }

    private static List<ITranslationEntry> combine(List<ITranslationEntry> left, Collection<ITranslationEntry> right) {
        left.addAll(right);
        return left;
    }

    protected static void logImplicitOverrides(Collection<ITranslationStore> storesWithImplicitOverrides) {
        String names = storesWithImplicitOverrides.stream().map(ITranslationStore::service).map(TextProviderService::type).map(IType::name).collect(Collectors.joining(", ", "[", "]"));
        SdkLog.warning((CharSequence)"There are TextProviderServices with common keys and the same @Order value: {}. To ensure a stable override of translations each service should have a unique @Order value!", (Object[])new Object[]{names});
    }

    public Stream<? extends IStackedTranslation> allTranslationsWithPrefix(String prefix) {
        return this.allTranslations().filter(t -> t.key().regionMatches(true, 0, prefix, 0, prefix.length()));
    }

    public String generateNewKey(CharSequence baseText) {
        if (Strings.isBlank((CharSequence)baseText)) {
            return "";
        }
        String cleaned = Pattern.compile("[^\\w.\\- ]*").matcher(baseText).replaceAll("");
        if (Strings.isBlank((CharSequence)cleaned)) {
            return "";
        }
        String[] segments = (String[])Pattern.compile(" ").splitAsStream(cleaned).filter(Strings::hasText).toArray(String[]::new);
        StringBuilder firstSegment = new StringBuilder(segments[0]);
        while (!(firstSegment.isEmpty() || firstSegment.charAt(0) >= 'a' && firstSegment.charAt(0) <= 'z' || firstSegment.charAt(0) >= 'A' && firstSegment.charAt(0) <= 'Z')) {
            firstSegment.deleteCharAt(0);
        }
        segments[0] = firstSegment.toString();
        if (segments.length > 1) {
            StringBuilder lastSegment = new StringBuilder(segments[segments.length - 1]);
            while (!(lastSegment.isEmpty() || lastSegment.charAt(lastSegment.length() - 1) != '.' && lastSegment.charAt(lastSegment.length() - 1) != '-')) {
                lastSegment.deleteCharAt(lastSegment.length() - 1);
            }
            segments[segments.length - 1] = lastSegment.toString();
        }
        String keyCandidate = segments.length < 2 ? segments[0] : Arrays.stream(segments).map(Strings::capitalize).collect(Collectors.joining());
        int maxLength = 190;
        if (keyCandidate.length() > maxLength) {
            keyCandidate = keyCandidate.substring(0, maxLength);
        }
        Object result = keyCandidate;
        int i = 0;
        while (this.containsKeyIgnoreCase((String)result)) {
            result = keyCandidate + i;
            ++i;
        }
        return result;
    }

    private boolean containsKeyIgnoreCase(String key) {
        return this.m_translations.keySet().stream().anyMatch(existing -> existing.equalsIgnoreCase(key));
    }

    public boolean isEditable() {
        return this.primaryEditableStore().isPresent();
    }

    public Optional<IStackedTranslation> translation(String key) {
        return Optional.ofNullable((IStackedTranslation)this.m_translations.get(key));
    }

    public boolean containsKey(String key) {
        return this.m_translations.containsKey(key);
    }

    public Stream<ITranslationStore> allEditableStores() {
        return this.allStores().filter(ITranslationStore::isEditable);
    }

    public Optional<ITranslationStore> primaryEditableStore() {
        return this.allEditableStores().findFirst();
    }

    public IStackedTranslation mergeTranslation(ITranslation newTranslation, ITranslationStore targetInCaseNew) {
        ITranslation merged = this.translation(newTranslation.key()).map(t -> t.merged(newTranslation)).orElse(newTranslation);
        return this.setTranslation(merged, targetInCaseNew);
    }

    public ITranslationImportInfo importTranslations(List<List<String>> rawTableData, String keyColumnName, ITranslationStore targetInCaseNew) {
        TranslationImporter importer = new TranslationImporter(this, rawTableData, keyColumnName, targetInCaseNew);
        importer.tryImport();
        return importer;
    }

    public void changeKey(String oldKey, String newKey) {
        if (Objects.equals(oldKey, newKey)) {
            return;
        }
        StackedTranslation entry = this.m_translations.get(oldKey);
        if (entry == null) {
            return;
        }
        Ensure.isTrue((boolean)entry.hasOnlyEditableStores(), (CharSequence)"Cannot change key '{}' to '{}' because some entries are read-only.", (Object[])new Object[]{oldKey, newKey});
        entry.stores().forEach(s -> Ensure.isFalse((boolean)TranslationValidator.isForbidden(TranslationValidator.validateKey(this, s, newKey)), (CharSequence)"Cannot change key '{}' to '{}' because the new key is not valid.", (Object[])new Object[]{oldKey, newKey}));
        this.runAndFireChanged(() -> this.changeKeyInternal(entry, oldKey, newKey));
    }

    protected TranslationManagerEvent changeKeyInternal(IStackedTranslation entry, String oldKey, String newKey) {
        List<ITranslationEntry> newEntries = entry.stores().map(TranslationManager::toEditableStore).map(store -> store.changeKey(oldKey, newKey)).collect(Collectors.toList());
        this.m_translations.remove(oldKey);
        StackedTranslation existingTranslationWithNewKey = this.m_translations.get(newKey);
        if (existingTranslationWithNewKey != null) {
            newEntries.forEach(existingTranslationWithNewKey::entryUpdated);
            this.fireManagerChanged(TranslationManagerEvent.createRemoveTranslationEvent(this, entry));
            return TranslationManagerEvent.createUpdateTranslationEvent(this, existingTranslationWithNewKey);
        }
        StackedTranslation newEntry = new StackedTranslation(newEntries);
        this.m_translations.put(newKey, newEntry);
        return TranslationManagerEvent.createChangeKeyEvent(this, newEntry, oldKey);
    }

    public void removeTranslations(Stream<String> keys) {
        if (keys == null) {
            return;
        }
        this.setChanging(true);
        try {
            keys.filter(Strings::hasText).map(this::removeTranslationInternal).forEach(this::fireManagerChanged);
        }
        finally {
            this.setChanging(false);
        }
    }

    protected TranslationManagerEvent removeTranslationInternal(String key) {
        StackedTranslation toRemove = this.m_translations.get(key);
        if (toRemove == null) {
            return null;
        }
        Ensure.isTrue((boolean)toRemove.hasOnlyEditableStores(), (CharSequence)"Cannot delete translation with key '{}' because some entries are read-only.", (Object[])new Object[]{key});
        toRemove.stores().map(TranslationManager::toEditableStore).forEach(store -> store.removeTranslation(key));
        this.m_translations.remove(key);
        return TranslationManagerEvent.createRemoveTranslationEvent(this, toRemove);
    }

    public IStackedTranslation setTranslation(ITranslation newTranslation) {
        return this.setTranslation(newTranslation, null);
    }

    public IStackedTranslation setTranslation(ITranslation newTranslation, ITranslationStore storeForNew) {
        return this.setTranslationInternal(newTranslation, storeForNew, false);
    }

    public IStackedTranslation setTranslationToStore(ITranslation newTranslation, ITranslationStore target) {
        return this.setTranslationInternal(newTranslation, target, true);
    }

    protected IStackedTranslation setTranslationInternal(ITranslation newTranslation, ITranslationStore targetStore, boolean enforceTargetStore) {
        Ensure.notNull((Object)newTranslation, (CharSequence)"A translation must be specified.", (Object[])new Object[0]);
        Ensure.isTrue((targetStore == null || this.m_stores.contains(targetStore) ? 1 : 0) != 0, (CharSequence)"Store of wrong manager.", (Object[])new Object[0]);
        Ensure.isFalse((boolean)TranslationValidator.isForbidden(TranslationValidator.validateKey(newTranslation.key())), (CharSequence)"Invalid key.", (Object[])new Object[0]);
        StackedTranslation existingEntry = this.m_translations.get(newTranslation.key());
        if (existingEntry == null || enforceTargetStore) {
            return this.setTranslationToSpecificStore(newTranslation, existingEntry, targetStore);
        }
        this.runAndFireChanged(() -> this.setTranslationToCurrentStores(newTranslation, existingEntry, targetStore));
        return existingEntry;
    }

    protected IStackedTranslation setTranslationToSpecificStore(ITranslation newTranslation, StackedTranslation existingEntry, ITranslationStore target) {
        IEditableTranslationStore editableStore = this.findStoreForTranslation(target, existingEntry);
        TranslationManager.validateDefaultText(newTranslation, existingEntry, editableStore);
        FinalValue result = new FinalValue();
        this.runAndFireChanged(() -> {
            ITranslationEntry createdTranslation = this.editStoreObservingLanguages(editableStore, s -> s.setTranslation(newTranslation));
            if (existingEntry == null) {
                StackedTranslation created = new StackedTranslation(List.of(createdTranslation));
                this.m_translations.put(created.key(), created);
                result.set((Object)created);
                return TranslationManagerEvent.createAddTranslationEvent(this, created);
            }
            existingEntry.entryUpdated(createdTranslation);
            result.set((Object)existingEntry);
            return TranslationManagerEvent.createUpdateTranslationEvent(this, existingEntry);
        });
        return (IStackedTranslation)result.get();
    }

    protected IEditableTranslationStore findStoreForTranslation(ITranslationStore explicit, IStackedTranslation toComputeDefaultStore) {
        return TranslationManager.toEditableStore(Optional.ofNullable(explicit).or(() -> Optional.ofNullable(toComputeDefaultStore).flatMap(IStackedTranslation::primaryEditableStore)).or(this::primaryEditableStore).orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot write entries. All translation stores are read-only.", (Object[])new Object[0])));
    }

    protected static void validateDefaultText(ITranslation newTranslation, IStackedTranslation existing, ITranslationStore target) {
        Ensure.isFalse((boolean)TranslationValidator.isForbidden(TranslationValidator.validateDefaultText(newTranslation, existing, target)), (CharSequence)"Translation validation failed. Ensure a valid default text is available.", (Object[])new Object[0]);
    }

    protected TranslationManagerEvent setTranslationToCurrentStores(ITranslation newTranslation, StackedTranslation entryToUpdate, ITranslationStore storeForNewLanguages) {
        IEditableTranslationStore storeForNew = this.findStoreForTranslation(storeForNewLanguages, entryToUpdate);
        Map<IEditableTranslationStore, List<Language>> changedLanguagesByStore = TranslationManager.changedLanguages(newTranslation, entryToUpdate).collect(Collectors.groupingBy(changedLang -> entryToUpdate.entry((Language)changedLang).map(ITranslationEntry::store).filter(ITranslationStore::isEditable).map(TranslationManager::toEditableStore).orElse(storeForNew)));
        changedLanguagesByStore.entrySet().stream().map(e -> this.writeTranslationToStore((IEditableTranslationStore)e.getKey(), (Collection)e.getValue(), newTranslation, entryToUpdate)).forEach(entryToUpdate::entryUpdated);
        return TranslationManagerEvent.createUpdateTranslationEvent(this, entryToUpdate);
    }

    protected ITranslationEntry writeTranslationToStore(IEditableTranslationStore store, Collection<Language> languagesToUpdate, ITranslation newTranslation, IStackedTranslation entryToUpdate) {
        if (languagesToUpdate.contains(Language.LANGUAGE_DEFAULT)) {
            TranslationManager.validateDefaultText(newTranslation, entryToUpdate, store);
        }
        String key = newTranslation.key();
        Translation updateForStore = store.get(key).map(Translation::new).orElseGet(() -> new Translation(key));
        languagesToUpdate.forEach(changedLang -> updateForStore.putText((Language)changedLang, newTranslation.text((Language)changedLang).orElse(null)));
        return this.editStoreObservingLanguages(store, s -> s.setTranslation(updateForStore));
    }

    protected static Stream<Language> changedLanguages(ITranslation a, ITranslation b) {
        return Stream.concat(TranslationManager.languagesDifferentInFirst(a, b), TranslationManager.languagesDifferentInFirst(b, a)).distinct();
    }

    protected static Stream<Language> languagesDifferentInFirst(ITranslation a, ITranslation b) {
        return a.texts().entrySet().stream().filter(e -> !Objects.equals(TranslationManager.textOrNull(b, (Language)e.getKey()), TranslationManager.textOrNull((String)e.getValue()))).map(Map.Entry::getKey);
    }

    protected static String textOrNull(String s) {
        return Strings.notBlank((CharSequence)s).orElse(null);
    }

    protected static String textOrNull(ITranslation translation, Language language) {
        return translation.text(language).filter(Strings::hasText).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T editStoreObservingLanguages(IEditableTranslationStore storeToObserve, Function<IEditableTranslationStore, T> task) {
        Set<Language> oldLanguages = storeToObserve.languages().collect(Collectors.toSet());
        try {
            T t = task.apply(storeToObserve);
            return t;
        }
        finally {
            this.fireAddLanguageForCreatedLanguages(storeToObserve, oldLanguages);
        }
    }

    protected void fireAddLanguageForCreatedLanguages(ITranslationStore storeToObserve, Collection<Language> oldLanguages) {
        storeToObserve.languages().filter(newLang -> !oldLanguages.contains(newLang)).map(lang -> TranslationManagerEvent.createAddLanguageEvent(this, lang)).forEach(this::fireManagerChanged);
    }

    public void addNewLanguage(Language lang, ITranslationStore target) {
        if (target.languages().anyMatch(Predicate.isEqual(lang))) {
            return;
        }
        Ensure.notNull((Object)lang, (CharSequence)"Language cannot be null.", (Object[])new Object[0]);
        Ensure.isTrue((boolean)this.m_stores.contains(target), (CharSequence)"Store of wrong manager.", (Object[])new Object[0]);
        IEditableTranslationStore editableStore = TranslationManager.toEditableStore(target);
        this.runAndFireChanged(() -> {
            editableStore.addNewLanguage(lang);
            return TranslationManagerEvent.createAddLanguageEvent(this, lang);
        });
    }

    public Stream<? extends IStackedTranslation> allTranslations() {
        return this.m_translations.values().stream();
    }

    public boolean isDirty() {
        return this.allEditableStores().map(TranslationManager::toEditableStore).anyMatch(IEditableTranslationStore::isDirty);
    }

    protected static IEditableTranslationStore toEditableStore(ITranslationStore store) {
        Ensure.instanceOf((Object)store, IEditableTranslationStore.class, (CharSequence)"Editable stores must implement {}.", (Object[])new Object[]{IEditableTranslationStore.class});
        Ensure.isTrue((boolean)store.isEditable(), (CharSequence)"Cannot modify store '{}' because it is read-only.", (Object[])new Object[]{store.service().type().name()});
        return (IEditableTranslationStore)store;
    }

    public void flush(IEnvironment env, IProgress progress) {
        this.runAndFireChanged(() -> {
            this.allEditableStores().map(TranslationManager::toEditableStore).forEach(store -> store.flush(env, progress));
            return TranslationManagerEvent.createFlushEvent(this);
        });
    }

    public void reload(IEnvironment env, IProgress progress) {
        this.runAndFireChanged(() -> {
            Path modulePath = this.modulePath().orElse(null);
            if (modulePath != null) {
                List<ITranslationStore> newStores = TranslationManager.sortStores(Translations.storesForModule(modulePath, env, progress, this.dependencyScopes()));
                this.m_stores.clear();
                this.m_stores.addAll(newStores);
            } else {
                progress.init(this.m_stores.size(), "Reload all translation stores.", new Object[0]);
                this.allStores().forEach(s -> s.reload(progress.newChild(1)));
            }
            this.m_translations.clear();
            this.m_translations.putAll(TranslationManager.buildStackedTranslations(this.m_stores.stream()));
            return TranslationManagerEvent.createReloadEvent(this);
        });
    }

    public Stream<ITranslationStore> allStores() {
        return this.m_stores.stream();
    }

    public Stream<Language> allLanguages() {
        return this.allStores().flatMap(ITranslationStore::languages).distinct();
    }

    public void setChanging(boolean changing) {
        if (changing) {
            ++this.m_changing;
        } else {
            --this.m_changing;
            if (!this.isChanging()) {
                this.fireBufferedEvents();
            }
        }
    }

    public boolean isChanging() {
        return this.m_changing > 0;
    }

    protected void runAndFireChanged(Supplier<TranslationManagerEvent> callable) {
        this.setChanging(true);
        try {
            this.fireManagerChanged(callable.get());
        }
        finally {
            this.setChanging(false);
        }
    }

    public void addListener(ITranslationManagerListener listener) {
        this.m_listeners.add((EventListener)listener);
    }

    public boolean removeListener(ITranslationManagerListener listener) {
        return this.m_listeners.remove((EventListener)listener);
    }

    public boolean contentEquals(TranslationManager other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.m_stores.equals(other.m_stores)) {
            return false;
        }
        return this.m_translations.equals(other.m_translations);
    }

    public Optional<Path> modulePath() {
        return Optional.ofNullable(this.m_modulePath);
    }

    public Translations.DependencyScope[] dependencyScopes() {
        return Arrays.copyOf(this.m_dependencyScopes, this.m_dependencyScopes.length);
    }

    protected synchronized void fireBufferedEvents() {
        if (this.m_eventBuffer.isEmpty()) {
            return;
        }
        try {
            if (this.m_listeners.isEmpty()) {
                return;
            }
            this.fireManagerChanged(new ArrayList<TranslationManagerEvent>(this.m_eventBuffer));
        }
        finally {
            this.m_eventBuffer.clear();
        }
    }

    protected void fireManagerChanged(Collection<TranslationManagerEvent> eventsToFire) {
        List listeners = this.m_listeners.get(ITranslationManagerListener.class);
        for (ITranslationManagerListener l : listeners) {
            l.managerChanged(eventsToFire.stream());
        }
    }

    protected synchronized void fireManagerChanged(TranslationManagerEvent event) {
        if (event == null) {
            return;
        }
        if (this.isChanging()) {
            this.m_eventBuffer.add(event);
            return;
        }
        this.fireManagerChanged(Collections.singleton(event));
    }

    public String toString() {
        return this.m_stores.stream().map(s -> String.valueOf(s) + "\n").collect(Collectors.joining("", TranslationManager.class.getSimpleName() + " [\n", "]"));
    }
}

