/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.environment.SdkFuture;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.service.ServiceInterfaceGenerator;
import org.eclipse.scout.sdk.core.s.testcase.TestGenerator;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ServiceNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private ITypeGenerator<?> m_serviceIfcBuilder;
    private IClasspathEntry m_sharedSourceFolder;
    private IClasspathEntry m_serverSourceFolder;
    private String m_sharedPackage;
    private String m_serviceName;
    private final List<IMethodGenerator<?, ?>> m_methods = new ArrayList();
    private IClasspathEntry m_testSourceFolder;
    private String m_serverSession;
    private boolean m_createTest;
    private IFuture<IType> m_createdServiceInterface;
    private String m_createdServiceInterfaceFqn;
    private IFuture<IType> m_createdServiceImpl;
    private String m_createdServiceImplFqn;
    private IFuture<IType> m_createdServiceTest;
    private String m_createdServiceTestFqn;

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        this.validateOperation();
        this.prepareProgress(progress);
        this.executeOperation(env, progress);
    }

    protected void validateOperation() {
        Ensure.notNull((Object)this.getSharedSourceFolder(), (CharSequence)"No shared source folder provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getServerSourceFolder(), (CharSequence)"No server source folder provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSharedPackage(), (CharSequence)"No shared package provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getServiceName(), (CharSequence)"No service base name provided", (Object[])new Object[0]);
        if (this.isCreateTest()) {
            Ensure.notNull((Object)this.getTestSourceFolder(), (CharSequence)"No test source folder provided", (Object[])new Object[0]);
        }
    }

    protected void prepareProgress(IProgress progress) {
        progress.init(this.getTotalWork(), this.toString(), new Object[0]);
    }

    protected void executeOperation(IEnvironment env, IProgress progress) {
        String serverPackage = ScoutTier.Shared.convert(ScoutTier.Server, this.getSharedPackage());
        String svcName = this.getServiceName() + "Service";
        this.setCreatedServiceInterface(this.createServiceIfc(svcName, this.getSharedPackage(), env, progress.newChild(1)));
        this.setCreatedServiceImpl(this.createServiceImpl(svcName, serverPackage, env, progress.newChild(1)));
        if (this.isCreateTest()) {
            this.setCreatedServiceTest(this.createServiceTest(env, progress.newChild(1)));
        }
    }

    protected int getTotalWork() {
        int result = 2;
        if (this.isCreateTest()) {
            ++result;
        }
        return result;
    }

    protected ICompilationUnitGenerator<?> createServiceImplGenerator(String svcName, String serverPackage) {
        IJavaEnvironment javaEnvironment = this.getServerSourceFolder().javaEnvironment();
        Optional existingServiceImpl = javaEnvironment.findType(serverPackage + "." + svcName);
        Object implBuilder = existingServiceImpl.isPresent() ? ((IType)existingServiceImpl.orElseThrow()).requireCompilationUnit().toWorkingCopy() : PrimaryTypeGenerator.create().withElementName(svcName).withPackageName(serverPackage);
        implBuilder.mainType().ifPresent(t -> t.withInterface(this.getServiceIfcBuilder().fullyQualifiedName()).withPreProcessor(this::addMissingImplMethods));
        return implBuilder;
    }

    protected void addMissingImplMethods(ITypeGenerator<?> svcImpl, IJavaBuilderContext context) {
        for (IMethodGenerator<?, ?> msb : this.getMethods()) {
            String methodIdToSearch = msb.identifier(context);
            Optional existingMethod = svcImpl.method(methodIdToSearch, context, false);
            if (!existingMethod.isEmpty()) continue;
            boolean existsInInterface = Flags.isInterface((int)msb.flags());
            if (existsInInterface) {
                ((IMethodGenerator)msb.asPublic()).withAnnotation(AnnotationGenerator.createOverride());
            }
            svcImpl.withMethod((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)msb.withFlags(msb.flags())).withoutFlags(512)).withComment(null), new Object[0]);
        }
    }

    protected IFuture<IType> createServiceImpl(String svcName, String serverPackage, IEnvironment env, IProgress progress) {
        ICompilationUnitGenerator<?> implBuilder = this.createServiceImplGenerator(svcName, serverPackage);
        implBuilder.mainType().ifPresent(gen -> this.setCreatedServiceImplFqn(gen.fullyQualifiedName()));
        return env.writeCompilationUnitAsync(implBuilder, this.getServerSourceFolder(), progress);
    }

    protected ICompilationUnitGenerator<?> createServiceIfcBuilder(String svcName, String sharedPackage) {
        String ifcName = "I" + svcName;
        IJavaEnvironment javaEnvironment = this.getSharedSourceFolder().javaEnvironment();
        Optional existingServiceIfc = javaEnvironment.findType(sharedPackage + "." + ifcName);
        ICompilationUnitGenerator ifcBuilder = existingServiceIfc.map(iType -> iType.requireCompilationUnit().toWorkingCopy()).orElseGet(() -> ((ServiceInterfaceGenerator)new ServiceInterfaceGenerator().withElementName(ifcName)).withPackageName(sharedPackage));
        ifcBuilder.mainType().ifPresent(t -> t.withPreProcessor(this::addMissingIfcMethods));
        return ifcBuilder;
    }

    protected void addMissingIfcMethods(ITypeGenerator<?> svcIfc, IJavaBuilderContext context) {
        for (IMethodGenerator<?, ?> msb : this.getMethods()) {
            String methodIdToSearch;
            Optional existingMethod;
            if (!Flags.isInterface((int)msb.flags()) || !(existingMethod = svcIfc.method(methodIdToSearch = msb.identifier(context), context, false)).isEmpty()) continue;
            svcIfc.withMethod((IMethodGenerator)msb.withoutFlags(1), new Object[0]);
        }
    }

    protected IFuture<IType> createServiceIfc(String svcName, String sharedPackage, IEnvironment env, IProgress progress) {
        ICompilationUnitGenerator<?> ifcBuilder = this.createServiceIfcBuilder(svcName, sharedPackage);
        ifcBuilder.mainType().ifPresent(gen -> this.setCreatedServiceInterfaceFqn(gen.fullyQualifiedName()));
        IFuture<IType> createdIfc = env.writeCompilationUnitAsync(ifcBuilder, this.getSharedSourceFolder(), progress);
        this.setServiceIfcBuilder(ifcBuilder.mainType().orElse(null));
        return createdIfc;
    }

    protected IFuture<IType> createServiceTest(IEnvironment env, IProgress progress) {
        IClasspathEntry testSourceFolder = this.getTestSourceFolder();
        String serverPackage = JavaTypes.qualifier((CharSequence)this.getCreatedServiceImplFqn());
        String baseName = JavaTypes.simpleName((CharSequence)this.getCreatedServiceImplFqn());
        String elementName = baseName + "Test";
        Optional existingServiceTest = testSourceFolder.javaEnvironment().findType(serverPackage + "." + elementName);
        if (existingServiceTest.isPresent()) {
            return SdkFuture.completed((IType)existingServiceTest.orElseThrow());
        }
        IScoutApi scoutApi = (IScoutApi)testSourceFolder.javaEnvironment().requireApi(IScoutApi.class);
        Object testBuilder = ((TestGenerator)((Object)((TestGenerator)((TestGenerator)new TestGenerator().withElementName(elementName)).withPackageName(serverPackage)).withRunner(scoutApi.ServerTestRunner().fqn()))).asClientTest(false);
        if (Strings.hasText((CharSequence)this.getServerSession())) {
            ((TestGenerator)((Object)testBuilder)).withSession(this.getServerSession());
        }
        this.setCreatedServiceTestFqn(testBuilder.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)testBuilder, testSourceFolder, progress);
    }

    public IClasspathEntry getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IClasspathEntry sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IClasspathEntry getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IClasspathEntry serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    protected ITypeGenerator<?> getServiceIfcBuilder() {
        return this.m_serviceIfcBuilder;
    }

    protected void setServiceIfcBuilder(ITypeGenerator<?> serviceIfcBuilder) {
        this.m_serviceIfcBuilder = serviceIfcBuilder;
    }

    public IFuture<IType> getCreatedServiceInterface() {
        return this.m_createdServiceInterface;
    }

    protected void setCreatedServiceInterface(IFuture<IType> createdServiceInterface) {
        this.m_createdServiceInterface = createdServiceInterface;
    }

    public String getCreatedServiceInterfaceFqn() {
        return this.m_createdServiceInterfaceFqn;
    }

    protected void setCreatedServiceInterfaceFqn(String createdServiceInterfaceFqn) {
        this.m_createdServiceInterfaceFqn = createdServiceInterfaceFqn;
    }

    public IFuture<IType> getCreatedServiceImpl() {
        return this.m_createdServiceImpl;
    }

    protected void setCreatedServiceTest(IFuture<IType> createdServiceTest) {
        this.m_createdServiceTest = createdServiceTest;
    }

    public IFuture<IType> getCreatedServiceTest() {
        return this.m_createdServiceTest;
    }

    protected void setCreatedServiceTestFqn(String createdServiceTestFqn) {
        this.m_createdServiceTestFqn = createdServiceTestFqn;
    }

    public String getCreatedServiceTestFqn() {
        return this.m_createdServiceTestFqn;
    }

    protected void setCreatedServiceImpl(IFuture<IType> createdServiceImpl) {
        this.m_createdServiceImpl = createdServiceImpl;
    }

    public String getCreatedServiceImplFqn() {
        return this.m_createdServiceImplFqn;
    }

    protected void setCreatedServiceImplFqn(String createdServiceImplFqn) {
        this.m_createdServiceImplFqn = createdServiceImplFqn;
    }

    public String getSharedPackage() {
        return this.m_sharedPackage;
    }

    public void setSharedPackage(String sharedPackage) {
        this.m_sharedPackage = sharedPackage;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void addMethod(IMethodGenerator<?, ?> msb) {
        this.m_methods.add(msb);
    }

    public List<IMethodGenerator<?, ?>> getMethods() {
        return this.m_methods;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public void setTestSourceFolder(IClasspathEntry testSourceFolder) {
        this.m_testSourceFolder = testSourceFolder;
    }

    public IClasspathEntry getTestSourceFolder() {
        return this.m_testSourceFolder;
    }

    public void setServerSession(String serverSession) {
        this.m_serverSession = serverSession;
    }

    public String getServerSession() {
        return this.m_serverSession;
    }

    public boolean isCreateTest() {
        return this.m_createTest;
    }

    public void setCreateTest(boolean createTest) {
        this.m_createTest = createTest;
    }

    public String toString() {
        return "Create new Service";
    }
}

