/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class UpdateClasspathJob
extends Job {
    IPluginModelBase[] fModels;

    public UpdateClasspathJob(IPluginModelBase[] models) {
        super(PDEUIMessages.UpdateClasspathJob_title);
        this.setPriority(30);
        this.fModels = models;
    }

    public boolean doUpdateClasspath(IProgressMonitor monitor, IPluginModelBase[] models) throws CoreException {
        monitor.beginTask(PDEUIMessages.UpdateClasspathJob_task, models.length);
        try {
            IPluginModelBase[] iPluginModelBaseArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                monitor.subTask(model.getPluginBase().getId());
                IProject project = model.getUnderlyingResource().getProject();
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    monitor.worked(1);
                } else {
                    IProjectDescription projDesc = project.getDescription();
                    if (projDesc != null) {
                        projDesc.setReferencedProjects(new IProject[0]);
                        project.setDescription(projDesc, null);
                        IFile file = project.getFile(".project");
                        if (file.exists()) {
                            file.deleteMarkers("org.eclipse.pde.core.problem", true, 0);
                        }
                        ClasspathComputer.setClasspath((IProject)project, (IPluginModelBase)model);
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            return false;
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            UpdateClasspathWorkspaceRunnable runnable = new UpdateClasspathWorkspaceRunnable();
            PDEPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, monitor);
            if (runnable.isCanceled()) {
                return new Status(8, "org.eclipse.pde.ui", 8, "", null);
            }
        }
        catch (CoreException e) {
            String title = PDEUIMessages.UpdateClasspathJob_error_title;
            String message = PDEUIMessages.UpdateClasspathJob_error_message;
            PDEPlugin.logException(e, title, message);
            return new Status(4, "org.eclipse.pde.ui", 0, message, (Throwable)e);
        }
        return new Status(0, "org.eclipse.pde.ui", 0, "", null);
    }

    class UpdateClasspathWorkspaceRunnable
    implements IWorkspaceRunnable {
        boolean fCanceled = false;

        UpdateClasspathWorkspaceRunnable() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            this.fCanceled = UpdateClasspathJob.this.doUpdateClasspath(monitor, UpdateClasspathJob.this.fModels);
        }

        public boolean isCanceled() {
            return this.fCanceled;
        }
    }
}

