/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class SetObjectLabelAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        try {
            IValue value;
            String name;
            if (element instanceof IJavaVariable) {
                IJavaVariable variable = (IJavaVariable)element;
                name = variable.getName();
                value = variable.getValue();
            } else if (element instanceof JavaInspectExpression) {
                JavaInspectExpression jie = (JavaInspectExpression)((Object)element);
                name = jie.getExpressionText();
                value = jie.getValue();
            } else {
                return;
            }
            if (value instanceof IJavaObject) {
                IJavaObject javaValue = (IJavaObject)value;
                this.askForLabel(javaValue, name);
            }
        }
        catch (DebugException debugException) {
            return;
        }
    }

    private void askForLabel(IJavaObject javaValue, String variableName) throws DebugException {
        String currentLabel = javaValue.getLabel();
        InputDialog dialog = new InputDialog(JDIDebugUIPlugin.getShell(), ActionMessages.SetObjectLabel_title, ActionMessages.SetObjectLabel_message, currentLabel != null ? currentLabel : variableName, null);
        if (dialog.open() != 0) {
            return;
        }
        javaValue.setLabel(dialog.getValue());
        this.refresh();
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.getPart().getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    private void refresh() {
        StructuredViewer viewer = this.getStructuredViewer();
        if (viewer != null) {
            viewer.refresh();
        }
    }
}

