/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSParam;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTask;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSFileValidator;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details.CompCSEnclosingTextDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details.DetailsMessages;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.NewSimpleCSFileWizard;
import org.eclipse.pde.internal.ua.ui.wizards.cheatsheet.SimpleCSFileWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.pde.internal.ui.util.FileExtensionFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CompCSTaskDetails
extends CSAbstractDetails {
    private Section fDefinitionSection = null;
    private FormEntry fNameEntry = null;
    private FormEntry fPathEntry = null;
    private Button fSkip = null;
    private ICompCSTask fDataTask = null;
    private CompCSEnclosingTextDetails fEnclosingTextSection;
    private static final String F_PATH_SEPARATOR = "/";
    private static final String F_DOT_DOT = "..";

    public CompCSTaskDetails(ICSMaster section) {
        super(section, "compcs-context");
        this.fEnclosingTextSection = new CompCSEnclosingTextDetails(2, section);
    }

    public void setData(ICompCSTask object) {
        this.fDataTask = object;
        this.fEnclosingTextSection.setData((ICompCSTaskObject)object);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.fEnclosingTextSection.initialize(form);
    }

    @Override
    public void createDetails(Composite parent) {
        int style = 384;
        this.fDefinitionSection = this.getPage().createUISection(parent, DetailsMessages.CompCSTaskDetails_title, DetailsMessages.CompCSTaskDetails_description, style);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fDefinitionSection);
        Composite sectionClient = this.getPage().createUISectionContainer((Composite)this.fDefinitionSection, 3);
        this.createUINameEntry(sectionClient);
        this.createUIPathEntry(sectionClient);
        this.createUISkipButton(sectionClient);
        this.fEnclosingTextSection.createDetails(parent);
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
        this.fDefinitionSection.setClient((Control)sectionClient);
        this.markDetailsPart((Control)this.fDefinitionSection);
    }

    private void createUINameEntry(Composite parent) {
        this.fNameEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), DetailsMessages.CompCSTaskDetails_name, 0);
    }

    private void createUIPathEntry(Composite parent) {
        this.fPathEntry = new FormEntry(parent, this.getManagedForm().getToolkit(), DetailsMessages.CompCSTaskDetails_path, DetailsMessages.CompCSTaskDetails_browse, this.isEditable());
    }

    private void createUISkipButton(Composite parent) {
        Color foreground = this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fSkip = this.getToolkit().createButton(parent, DetailsMessages.CompCSTaskDetails_optional, 32);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSkip.setLayoutData((Object)data);
        this.fSkip.setForeground(foreground);
    }

    @Override
    public void hookListeners() {
        this.createListenersNameEntry();
        this.createListenersPathEntry();
        this.createListenersSkipButton();
        this.fEnclosingTextSection.hookListeners();
    }

    private void createListenersNameEntry() {
        this.fNameEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (CompCSTaskDetails.this.fDataTask == null) {
                    return;
                }
                CompCSTaskDetails.this.fDataTask.setFieldName(CompCSTaskDetails.this.fNameEntry.getValue());
            }
        });
    }

    private void createListenersPathEntry() {
        this.fPathEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this){

            public void browseButtonSelected(FormEntry entry) {
                if (CompCSTaskDetails.this.fDataTask == null) {
                    return;
                }
                CompCSTaskDetails.this.handleButtonEventPathEntry(entry);
            }

            public void linkActivated(HyperlinkEvent e) {
                if (CompCSTaskDetails.this.fDataTask == null) {
                    return;
                }
                CompCSTaskDetails.this.handleLinkEventPathEntry(CompCSTaskDetails.this.convertPathRelativeToAbs(CompCSTaskDetails.this.fPathEntry.getValue(), CompCSTaskDetails.this.fDataTask.getModel().getUnderlyingResource().getFullPath().toPortableString()));
            }

            public void textValueChanged(FormEntry entry) {
                if (CompCSTaskDetails.this.fDataTask == null) {
                    return;
                }
                CompCSTaskDetails.this.handleTextEventPathEntry(entry.getValue());
            }
        });
    }

    private void handleButtonEventPathEntry(FormEntry entry) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getManagedForm().getForm().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new CompCSFileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(DetailsMessages.CompCSTaskDetails_wizardTitle);
        dialog.setMessage(DetailsMessages.CompCSTaskDetails_wizardDescription);
        dialog.addFilter((ViewerFilter)new FileExtensionFilter("xml"));
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProject(this.fDataTask.getModel().getUnderlyingResource().getProject().getName()));
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            String newValue = this.convertPathAbsToRelative(file.getFullPath().toPortableString(), this.fDataTask.getModel().getUnderlyingResource().getFullPath().toPortableString());
            entry.setValue(newValue);
            this.handleTextEventPathEntry(newValue);
        }
    }

    private String extractFileName(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, F_PATH_SEPARATOR);
        while (tokenizer.countTokens() > 1) {
            tokenizer.nextToken();
        }
        return tokenizer.nextToken();
    }

    /*
     * Unable to fully structure code
     */
    private String convertPathAbsToRelative(String relativePath, String basePath) {
        convertPathTokenizer = new StringTokenizer(relativePath, "/");
        basePathTokenizer = new StringTokenizer(basePath, "/");
        convertPathToken = convertPathTokenizer.nextToken();
        if (convertPathToken.equals(basePathToken = basePathTokenizer.nextToken())) ** GOTO lbl13
        return "";
lbl-1000:
        // 1 sources

        {
            if (basePathTokenizer.countTokens() == 1) {
                return this.createRelativePath(0, null, convertPathTokenizer);
            }
            if (convertPathTokenizer.countTokens() == 1) {
                return this.createRelativePath(basePathTokenizer.countTokens() - 1, null, convertPathTokenizer);
            }
            convertPathToken = convertPathTokenizer.nextToken();
            if (convertPathToken.equals(basePathToken = basePathTokenizer.nextToken())) continue;
            return this.createRelativePath(basePathTokenizer.countTokens(), convertPathToken, convertPathTokenizer);
lbl13:
            // 2 sources

            ** while (basePathTokenizer.hasMoreTokens() && convertPathTokenizer.hasMoreTokens())
        }
lbl14:
        // 1 sources

        return "";
    }

    private String createRelativePath(int dotDotCount, String lastToken, StringTokenizer tokenizer) {
        StringBuilder relativePath = new StringBuilder();
        int i = 0;
        while (i < dotDotCount) {
            relativePath.append(F_DOT_DOT);
            relativePath.append(F_PATH_SEPARATOR);
            ++i;
        }
        if (lastToken != null) {
            relativePath.append(lastToken);
            relativePath.append(F_PATH_SEPARATOR);
        }
        i = 0;
        while (i < tokenizer.countTokens() - 1) {
            relativePath.append(tokenizer.nextToken());
            relativePath.append(F_PATH_SEPARATOR);
            ++i;
        }
        relativePath.append(tokenizer.nextToken());
        return relativePath.toString();
    }

    private void handleLinkEventPathEntry(String absolutePath) {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        Path path = new Path(absolutePath);
        if (path.isEmpty()) {
            this.handleLinkWizardPathEntry();
            return;
        }
        IResource resource = root.findMember((IPath)path);
        if (resource != null && resource instanceof IFile) {
            try {
                IDE.openEditor((IWorkbenchPage)PDEUserAssistanceUIPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
            }
            catch (PartInitException partInitException) {}
        } else {
            this.handleLinkWizardPathEntry();
        }
    }

    private void handleLinkWizardPathEntry() {
        NewSimpleCSFileWizard wizard = new NewSimpleCSFileWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.fDataTask.getModel().getUnderlyingResource()));
        WizardDialog dialog = new WizardDialog(PDEUserAssistanceUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        IWizardPage wizardPage = wizard.getPage("simple-cheatsheet");
        if (!(wizardPage instanceof SimpleCSFileWizardPage)) {
            return;
        }
        SimpleCSFileWizardPage page = (SimpleCSFileWizardPage)wizardPage;
        String initialValue = this.fPathEntry.getValue().trim();
        if (initialValue.length() > 0) {
            page.setFileName(this.extractFileName(initialValue));
        }
        page.setProjectName(this.fDataTask.getModel().getUnderlyingResource().getProject().getName());
        if (dialog.open() == 0) {
            String newValue = this.convertPathAbsToRelative(page.getAbsoluteFileName(), this.fDataTask.getModel().getUnderlyingResource().getFullPath().toPortableString());
            this.fPathEntry.setValue(newValue, true);
            this.handleTextEventPathEntry(newValue);
        }
    }

    private String convertPathRelativeToAbs(String relativePath, String basePath) {
        int baseSegementCount;
        StringTokenizer convertPathTokenizer = new StringTokenizer(relativePath, F_PATH_SEPARATOR);
        StringTokenizer basePathTokenizer = new StringTokenizer(basePath, F_PATH_SEPARATOR);
        StringBuilder endPath = new StringBuilder();
        int dotDotCount = 0;
        if (convertPathTokenizer.hasMoreTokens()) {
            while (convertPathTokenizer.countTokens() > 1) {
                String token = convertPathTokenizer.nextToken();
                if (token.equals(F_DOT_DOT)) {
                    ++dotDotCount;
                    continue;
                }
                endPath.append(token);
                endPath.append(F_PATH_SEPARATOR);
            }
            endPath.append(convertPathTokenizer.nextToken());
        }
        if ((baseSegementCount = basePathTokenizer.countTokens() - dotDotCount - 1) < 0) {
            return "";
        }
        StringBuilder startPath = new StringBuilder(F_PATH_SEPARATOR);
        int i = 0;
        while (i < baseSegementCount) {
            startPath.append(basePathTokenizer.nextToken());
            startPath.append(F_PATH_SEPARATOR);
            ++i;
        }
        return String.valueOf(startPath.toString()) + endPath.toString();
    }

    private void handleTextEventPathEntry(String newValue) {
        if (this.fDataTask.hasFieldParams()) {
            ICompCSParam parameter = this.fDataTask.getFieldParam("path");
            if (parameter != null) {
                parameter.setFieldValue(newValue);
            } else {
                this.createTaskParamPathEntry(newValue);
            }
        } else {
            this.createTaskParamPathEntry(newValue);
        }
    }

    private void createTaskParamPathEntry(String newValue) {
        ICompCSModelFactory factory = this.fDataTask.getModel().getFactory();
        ICompCSParam parameter = factory.createCompCSParam((ICompCSObject)this.fDataTask);
        parameter.setFieldName("path");
        parameter.setFieldValue(newValue);
        this.fDataTask.addFieldParam(parameter);
    }

    private void createListenersSkipButton() {
        this.fSkip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CompCSTaskDetails.this.fDataTask == null) {
                    return;
                }
                CompCSTaskDetails.this.fDataTask.setFieldSkip(CompCSTaskDetails.this.fSkip.getSelection());
            }
        });
    }

    @Override
    public void updateFields() {
        if (this.fDataTask == null) {
            return;
        }
        boolean editable = this.isEditableElement();
        this.updateNameEntry(editable);
        this.updatePathEntry(editable);
        this.updateSkipButton(editable);
        this.fEnclosingTextSection.updateFields();
    }

    private void updateNameEntry(boolean editable) {
        this.fNameEntry.setValue(this.fDataTask.getFieldName(), true);
        this.fNameEntry.setEditable(editable);
    }

    private void updatePathEntry(boolean editable) {
        ICompCSParam parameter = this.fDataTask.getFieldParam("path");
        if (parameter != null) {
            this.fPathEntry.setValue(parameter.getFieldValue(), true);
        } else {
            this.fPathEntry.setValue("", true);
        }
    }

    private void updateSkipButton(boolean editable) {
        this.fSkip.setSelection(this.fDataTask.getFieldSkip());
        this.fSkip.setEnabled(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fNameEntry.commit();
        this.fPathEntry.commit();
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object == null || !(object instanceof ICompCSTask)) {
            return;
        }
        this.setData((ICompCSTask)object);
        this.updateFields();
    }

    public void dispose() {
        if (this.fEnclosingTextSection != null) {
            this.fEnclosingTextSection.dispose();
            this.fEnclosingTextSection = null;
        }
        super.dispose();
    }
}

