/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.handlers.WidgetMethodHandler;

public class SelectAllHandler
extends WidgetMethodHandler {
    private static final Class<?>[] METHOD_PARAMETERS = new Class[]{Point.class};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        Method methodToExecute = this.getMethodToExecute();
        if (methodToExecute == null) return null;
        try {
            Control focusControl = Display.getCurrent().getFocusControl();
            int numParams = methodToExecute.getParameterTypes().length;
            if (focusControl instanceof Composite && (((Composite)focusControl).getStyle() & 0x1000000) != 0) {
                if (numParams != 0) {
                    return null;
                }
                try {
                    Object focusComponent = this.getFocusComponent();
                    if (focusComponent == null) return null;
                    Runnable methodRunnable = () -> {
                        try {
                            methodToExecute.invoke(focusComponent, new Object[0]);
                            focusControl.getDisplay().asyncExec(() -> {
                                if (!focusControl.isDisposed()) {
                                    focusControl.notifyListeners(13, null);
                                }
                            });
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException e2) {
                            focusControl.getDisplay().asyncExec(() -> ExceptionHandler.getInstance().handleException(new ExecutionException("An exception occurred while executing " + methodToExecute.getName(), e2.getTargetException())));
                        }
                    };
                    this.swingInvokeLater(methodRunnable);
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new Error("Something is seriously wrong here");
                }
            }
            if (numParams == 0) {
                methodToExecute.invoke((Object)focusControl, new Object[0]);
                focusControl.notifyListeners(13, null);
                return null;
            }
            if (numParams != 1) throw new ExecutionException("Too many parameters on select all", (Throwable)new Exception());
            Method textLimitAccessor = focusControl.getClass().getMethod("getTextLimit", new Class[0]);
            Integer textLimit = (Integer)textLimitAccessor.invoke((Object)focusControl, new Object[0]);
            Object[] parameters = new Object[]{new Point(0, textLimit.intValue())};
            methodToExecute.invoke((Object)focusControl, parameters);
            if (focusControl instanceof Combo) return null;
            focusControl.notifyListeners(13, null);
            return null;
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("An exception occurred while executing " + this.getMethodToExecute(), e.getTargetException());
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        return null;
    }

    @Override
    protected Method getMethodToExecute() {
        Control focusControl;
        Method method = super.getMethodToExecute();
        if (method == null && (focusControl = Display.getCurrent().getFocusControl()) != null) {
            try {
                method = focusControl.getClass().getMethod("setSelection", METHOD_PARAMETERS);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return method;
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.methodName = "selectAll";
    }
}

