/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MarkerLinkOpener
implements ILinkOpener {
    @Override
    public int supportsLink(LinkData link) {
        try {
            URI uri = new URI(link.href);
            if ("marker".equals(uri.getScheme())) {
                return 1;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return -1;
    }

    protected IPath getPath(LinkData link) {
        try {
            URI uri = new URI(link.href);
            if (uri.getPath() != null) {
                Path path = new Path(uri.getPath());
                return path.removeFirstSegments(1);
            }
        }
        catch (URISyntaxException e) {
            return new Path(link.href);
        }
        return null;
    }

    protected String getMarkerType(LinkData link) {
        try {
            Path path;
            URI uri = new URI(link.href);
            if (uri.getPath() != null && (path = new Path(uri.getPath())).segmentCount() > 0) {
                return path.segment(0);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    protected Object getMarkerAttributeValue(String name, String valueString) {
        Object value = valueString;
        try {
            value = Integer.valueOf(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    protected void addMarkerAttributes(LinkData link, Map<String, Object> attributes) {
        block9: {
            try {
                String query;
                URI uri = new URI(link.href);
                String lineNum = uri.getFragment();
                if (lineNum != null) {
                    try {
                        attributes.put("lineNumber", Integer.valueOf(lineNum));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((query = uri.getQuery()) == null) break block9;
                String[] stringArray = query.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String queryArg = stringArray[n2];
                    int pos = queryArg.indexOf(61);
                    String attributeName = queryArg.substring(0, pos);
                    String valueString = queryArg.substring(pos + 1);
                    Object value = this.getMarkerAttributeValue(attributeName, valueString);
                    try {
                        value = Integer.valueOf(valueString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    attributes.put(attributeName, value);
                    ++n2;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static String createMarkerLink(String markerType, String path, String ... args) {
        String link = "marker:/" + markerType + path;
        if (args.length > 0) {
            link = String.valueOf(link) + "?";
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    link = String.valueOf(link) + "&";
                }
                link = String.valueOf(link) + args[i] + "=" + args[i + 1];
                i += 2;
            }
        }
        return link;
    }

    protected IMarker createMarker(LinkData link, IFile file) {
        IMarker marker = null;
        try {
            marker = file.createMarker(this.getMarkerType(link));
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            this.addMarkerAttributes(link, attributes);
            marker.setAttributes(attributes);
            return marker;
        }
        catch (CoreException coreException) {
            return marker;
        }
    }

    @Override
    public void openLink(LinkData link) {
        block12: {
            IMarker marker = null;
            try {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IPath path = this.getPath(link);
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    marker = this.createMarker(link, file);
                    IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
                }
                catch (PartInitException partInitException) {
                    if (marker == null) break block12;
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {}
                }
            }
            finally {
                if (marker != null) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {}
                }
            }
        }
    }
}

