/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.xplain;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINTableDescriptor;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class XPLAINSystemTableVisitor
implements XPLAINVisitor {
    private boolean no_call_stmts = true;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private Activation activation;
    private boolean considerTimingInformation = false;
    private XPLAINStatementDescriptor stmt;
    private XPLAINStatementTimingsDescriptor stmtTimings = null;
    private UUID stmtUUID;
    private List rsets = new ArrayList();
    private List rsetsTimings = new ArrayList();
    private List sortrsets = new ArrayList();
    private List scanrsets = new ArrayList();
    private int noChildren;
    private Stack UUIDStack = new Stack();

    private void pushUUIDnoChildren(UUID uUID) {
        for (int i = 0; i < this.noChildren; ++i) {
            this.UUIDStack.push(uUID);
        }
    }

    public void setNumberOfChildren(int n) {
        this.noChildren = n;
    }

    public void visit(ResultSetStatistics resultSetStatistics) {
        UUID uUID;
        Object object;
        UUID uUID2 = null;
        if (this.considerTimingInformation) {
            uUID2 = this.dd.getUUIDFactory().createUUID();
            this.rsetsTimings.add(resultSetStatistics.getResultSetTimingsDescriptor(uUID2));
        }
        if ((object = resultSetStatistics.getSortPropsDescriptor(uUID = this.dd.getUUIDFactory().createUUID())) != null) {
            this.sortrsets.add(object);
        } else {
            uUID = null;
        }
        UUID uUID3 = this.dd.getUUIDFactory().createUUID();
        Object object2 = resultSetStatistics.getScanPropsDescriptor(uUID3);
        if (object2 != null) {
            this.scanrsets.add(object2);
        } else {
            uUID3 = null;
        }
        UUID uUID4 = this.dd.getUUIDFactory().createUUID();
        this.rsets.add(resultSetStatistics.getResultSetDescriptor(uUID4, this.UUIDStack.empty() ? null : (UUID)this.UUIDStack.pop(), uUID3, uUID, this.stmtUUID, uUID2));
        this.pushUUIDnoChildren(uUID4);
    }

    public void reset() {
        this.lcc = this.activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
    }

    public void doXPLAIN(RunTimeStatistics runTimeStatistics, Activation activation) throws StandardException {
        Object object;
        Object object2;
        this.activation = activation;
        this.reset();
        this.considerTimingInformation = this.lcc.getStatisticsTiming();
        UUID uUID = null;
        if (this.considerTimingInformation) {
            uUID = this.dd.getUUIDFactory().createUUID();
            object2 = runTimeStatistics.getEndExecutionTimestamp();
            object = runTimeStatistics.getBeginExecutionTimestamp();
            long l = object2 != null && object != null ? ((Timestamp)object2).getTime() - ((Timestamp)object).getTime() : 0L;
            this.stmtTimings = new XPLAINStatementTimingsDescriptor(uUID, new Long(runTimeStatistics.getParseTimeInMillis()), new Long(runTimeStatistics.getBindTimeInMillis()), new Long(runTimeStatistics.getOptimizeTimeInMillis()), new Long(runTimeStatistics.getGenerateTimeInMillis()), new Long(runTimeStatistics.getCompileTimeInMillis()), new Long(l), runTimeStatistics.getBeginCompilationTimestamp(), runTimeStatistics.getEndCompilationTimestamp(), runTimeStatistics.getBeginExecutionTimestamp(), runTimeStatistics.getEndExecutionTimestamp());
        }
        this.stmtUUID = this.dd.getUUIDFactory().createUUID();
        object2 = XPLAINUtil.getStatementType(runTimeStatistics.getStatementText());
        if (((String)object2).equalsIgnoreCase("C") && this.no_call_stmts) {
            return;
        }
        object = this.lcc.getTransactionExecute().getTransactionIdString();
        String string = Integer.toString(this.lcc.getInstanceNumber());
        String string2 = Integer.toString(JVMInfo.JDK_ID);
        String string3 = System.getProperty("os.name");
        long l = System.currentTimeMillis();
        String string4 = this.lcc.getXplainOnlyMode() ? "O" : "F";
        Timestamp timestamp = new Timestamp(l);
        String string5 = Thread.currentThread().toString();
        this.stmt = new XPLAINStatementDescriptor(this.stmtUUID, runTimeStatistics.getStatementName(), (String)object2, runTimeStatistics.getStatementText(), string2, string3, string4, timestamp, string5, (String)object, string, this.lcc.getDbname(), this.lcc.getDrdaID(), uUID);
        try {
            this.addStmtDescriptorsToSystemCatalog();
            runTimeStatistics.acceptFromTopResultSet(this);
            this.addArraysToSystemCatalogs();
        }
        catch (SQLException sQLException) {
            throw StandardException.plainWrapException(sQLException);
        }
        this.clean();
    }

    private void clean() {
        this.activation = null;
        this.lcc = null;
        this.dd = null;
        this.stmtUUID = null;
        this.stmt = null;
        this.stmtTimings = null;
        this.rsets.clear();
        this.rsetsTimings.clear();
        this.sortrsets.clear();
        this.scanrsets.clear();
        this.UUIDStack.clear();
    }

    private Connection getDefaultConn() throws SQLException {
        ConnectionContext connectionContext = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
        return connectionContext.getNestedConnection(true);
    }

    private void addStmtDescriptorsToSystemCatalog() throws StandardException, SQLException {
        boolean bl = this.lcc.getRunTimeStatisticsMode();
        this.lcc.setRunTimeStatisticsMode(false);
        Connection connection = this.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_STATEMENTS"));
        this.stmt.setStatementParameters(preparedStatement);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        if (this.considerTimingInformation) {
            preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_STATEMENT_TIMINGS"));
            this.stmtTimings.setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        connection.close();
        this.lcc.setRunTimeStatisticsMode(bl);
    }

    private void addArraysToSystemCatalogs() throws StandardException, SQLException {
        XPLAINTableDescriptor xPLAINTableDescriptor;
        boolean bl = this.lcc.getRunTimeStatisticsMode();
        this.lcc.setRunTimeStatisticsMode(false);
        Connection connection = this.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_RESULTSETS"));
        Iterator iterator = this.rsets.iterator();
        while (iterator.hasNext()) {
            xPLAINTableDescriptor = (XPLAINResultSetDescriptor)iterator.next();
            ((XPLAINResultSetDescriptor)xPLAINTableDescriptor).setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        if (this.considerTimingInformation) {
            preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_RESULTSET_TIMINGS"));
            iterator = this.rsetsTimings.iterator();
            while (iterator.hasNext()) {
                xPLAINTableDescriptor = (XPLAINResultSetTimingsDescriptor)iterator.next();
                ((XPLAINResultSetTimingsDescriptor)xPLAINTableDescriptor).setStatementParameters(preparedStatement);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
        }
        preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_SCAN_PROPS"));
        iterator = this.scanrsets.iterator();
        while (iterator.hasNext()) {
            xPLAINTableDescriptor = (XPLAINScanPropsDescriptor)iterator.next();
            ((XPLAINScanPropsDescriptor)xPLAINTableDescriptor).setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        preparedStatement = connection.prepareStatement((String)this.lcc.getXplainStatement("SYSXPLAIN_SORT_PROPS"));
        iterator = this.sortrsets.iterator();
        while (iterator.hasNext()) {
            xPLAINTableDescriptor = (XPLAINSortPropsDescriptor)iterator.next();
            ((XPLAINSortPropsDescriptor)xPLAINTableDescriptor).setStatementParameters(preparedStatement);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.close();
        this.lcc.setRunTimeStatisticsMode(bl);
    }
}

