/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.api;

import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;

public enum Environments implements Environment
{
    EE_INJECT(new EnvironmentBuilder().addRequiredDeploymentService(TransactionServices.class).addRequiredDeploymentService(SecurityServices.class).addRequiredBeanDeploymentArchiveService(ResourceLoader.class).addRequiredBeanDeploymentArchiveService(JpaInjectionServices.class).addRequiredBeanDeploymentArchiveService(ResourceInjectionServices.class).addRequiredBeanDeploymentArchiveService(EjbInjectionServices.class)),
    EE(new EnvironmentBuilder().addRequiredDeploymentService(TransactionServices.class).addRequiredDeploymentService(SecurityServices.class).addRequiredBeanDeploymentArchiveService(ResourceLoader.class).addRequiredBeanDeploymentArchiveService(InjectionServices.class)),
    SERVLET(new EnvironmentBuilder().addRequiredBeanDeploymentArchiveService(ResourceLoader.class)),
    SE(new EnvironmentBuilder().addRequiredBeanDeploymentArchiveService(ResourceLoader.class).setEEModulesAware(false));

    private final Set<Class<? extends Service>> requiredDeploymentServices;
    private final Set<Class<? extends Service>> requiredBeanDeploymentArchiveServices;
    private boolean eeModuleAware = true;

    private Environments(EnvironmentBuilder builder) {
        this.requiredDeploymentServices = builder.getRequiredDeploymentServices();
        this.requiredBeanDeploymentArchiveServices = builder.getRequiredBeanDeploymentArchiveServices();
        this.eeModuleAware = builder.isEEModuleAware();
    }

    @Override
    public Set<Class<? extends Service>> getRequiredDeploymentServices() {
        return this.requiredDeploymentServices;
    }

    @Override
    public Set<Class<? extends Service>> getRequiredBeanDeploymentArchiveServices() {
        return this.requiredBeanDeploymentArchiveServices;
    }

    @Override
    public boolean isEEModulesAware() {
        return this.eeModuleAware;
    }

    private static class EnvironmentBuilder {
        private final Set<Class<? extends Service>> requiredDeploymentServices;
        private final Set<Class<? extends Service>> requiredBeanDeploymentArchiveServices = new HashSet<Class<? extends Service>>();
        private boolean eeModuleAware = true;

        private EnvironmentBuilder() {
            this.requiredDeploymentServices = new HashSet<Class<? extends Service>>();
        }

        private Set<Class<? extends Service>> getRequiredBeanDeploymentArchiveServices() {
            return this.requiredBeanDeploymentArchiveServices;
        }

        private Set<Class<? extends Service>> getRequiredDeploymentServices() {
            return this.requiredDeploymentServices;
        }

        private EnvironmentBuilder addRequiredDeploymentService(Class<? extends Service> service) {
            this.requiredDeploymentServices.add(service);
            return this;
        }

        private EnvironmentBuilder addRequiredBeanDeploymentArchiveService(Class<? extends Service> service) {
            this.requiredBeanDeploymentArchiveServices.add(service);
            return this;
        }

        private EnvironmentBuilder setEEModulesAware(boolean aware) {
            this.eeModuleAware = aware;
            return this;
        }

        public boolean isEEModuleAware() {
            return this.eeModuleAware;
        }
    }
}

