/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataColumn;

public class DirectColumnMetadata
extends MetadataColumn {
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;

    public DirectColumnMetadata(MetadataAnnotation directColumn, MetadataAccessor accessor) {
        super(directColumn, accessor);
        if (directColumn != null) {
            this.m_nullable = directColumn.getAttributeBooleanDefaultTrue("nullable");
            this.m_updatable = directColumn.getAttributeBooleanDefaultTrue("updatable");
            this.m_insertable = directColumn.getAttributeBooleanDefaultTrue("insertable");
        }
    }

    protected DirectColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof DirectColumnMetadata) {
            DirectColumnMetadata directColumn = (DirectColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_nullable, directColumn.getNullable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_updatable, directColumn.getUpdatable())) {
                return false;
            }
            return this.valuesMatch(this.m_insertable, directColumn.getInsertable());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_nullable != null ? this.m_nullable.hashCode() : 0);
        result = 31 * result + (this.m_updatable != null ? this.m_updatable.hashCode() : 0);
        result = 31 * result + (this.m_insertable != null ? this.m_insertable.hashCode() : 0);
        return result;
    }

    @Override
    public DatabaseField getDatabaseField() {
        DatabaseField databaseField = super.getDatabaseField();
        databaseField.setNullable(this.m_nullable == null || this.m_nullable != false);
        databaseField.setUpdatable(this.m_updatable == null || this.m_updatable != false);
        databaseField.setInsertable(this.m_insertable == null || this.m_insertable != false);
        return databaseField;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public void setInsertable(Boolean insertable) {
        this.m_insertable = insertable;
    }

    public void setNullable(Boolean nullable) {
        this.m_nullable = nullable;
    }

    public void setUpdatable(Boolean updatable) {
        this.m_updatable = updatable;
    }
}

