/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.wss.WSITXMLFactory;
import jakarta.xml.ws.WebServiceException;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Claims
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.Claims,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;
    private byte[] claimsBytes;
    private Element claimsElement = null;

    public Claims() {
    }

    public Claims(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    @Override
    public byte[] getClaimsAsBytes() {
        this.populate();
        return this.claimsBytes;
    }

    @Override
    public Element getClaimsAsElement() {
        this.populate();
        if (this.claimsElement == null) {
            try {
                DocumentBuilderFactory dbf = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(this.claimsBytes));
                this.claimsElement = (Element)doc.getElementsByTagNameNS("*", "Claims").item(0);
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        return this.claimsElement;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean b) {
        if (!this.populated) {
            this.claimsBytes = PolicyUtil.policyAssertionToBytes(this);
            this.populated = true;
        }
        return this.fitness;
    }
}

