/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.enc;

import com.sun.xml.security.core.xenc.CVAdapter;
import com.sun.xml.security.core.xenc.EncryptedKeyType;
import com.sun.xml.security.core.xenc.ObjectFactory;
import com.sun.xml.security.core.xenc.ReferenceList;
import com.sun.xml.security.core.xenc.ReferenceType;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.security.opt.api.EncryptedKey;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.XMLStructure;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.jaxb.runtime.api.Bridge;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;

public class JAXBEncryptedKey
implements EncryptedKey,
SecurityHeaderElement,
SecurityElementWriter {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private EncryptedKeyType ekt = null;
    private Key dataEnckey = null;
    private Key dkEK = null;
    CryptoProcessor dep = null;
    private SOAPVersion soapVersion = SOAPVersion.SOAP_11;

    public JAXBEncryptedKey(EncryptedKeyType ekt, Key kk, Key dk, SOAPVersion soapVersion) throws XWSSecurityException {
        this.ekt = ekt;
        this.dkEK = kk;
        this.dataEnckey = dk;
        this.soapVersion = soapVersion;
        this.dep = new CryptoProcessor(3, ekt.getEncryptionMethod().getAlgorithm(), this.dataEnckey, this.dkEK);
    }

    public void encrypt() {
    }

    public void decrypt() {
    }

    @Override
    public String getId() {
        return this.ekt.getId();
    }

    @Override
    public void setId(String id) {
        this.ekt.setId(id);
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    @Override
    public String getLocalPart() {
        return "EncryptedKey";
    }

    public String getAttribute(String nsUri, String localName) {
        throw new UnsupportedOperationException();
    }

    public String getAttribute(QName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLStreamReader readHeader() {
        throw new UnsupportedOperationException();
    }

    public <T> T readAsJAXB(Unmarshaller unmarshaller) {
        throw new UnsupportedOperationException();
    }

    public <T> T readAsJAXB(Bridge<T> bridge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        try {
            OutputStream os;
            if (streamWriter instanceof Map && (os = (OutputStream)((Map)((Object)streamWriter)).get("sjsxp-outputstream")) != null) {
                streamWriter.writeCharacters("");
                this.writeTo(os);
                return;
            }
            Marshaller writer = this.getMarshaller();
            JAXBElement ed = this.getEK(writer);
            writer.marshal((Object)ed, streamWriter);
        }
        catch (JAXBException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1921_ERROR_WRITING_ENCRYPTEDKEY(ex.getMessage()), ex);
        }
    }

    @Override
    public void writeTo(OutputStream os) {
        try {
            Marshaller writer = this.getMarshaller();
            JAXBElement ed = this.getEK(writer);
            writer.marshal((Object)ed, os);
        }
        catch (JAXBException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1921_ERROR_WRITING_ENCRYPTEDKEY(ex.getMessage()), ex);
        }
    }

    private JAXBElement getEK(Marshaller writer) {
        CVAdapter adapter = new CVAdapter(this.dep);
        writer.setAdapter(CVAdapter.class, (XmlAdapter)adapter);
        ObjectFactory obj = new ObjectFactory();
        return obj.createEncryptedKey(this.ekt);
    }

    public void writeTo(SOAPMessage saaj) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) {
        throw new UnsupportedOperationException();
    }

    public byte[] canonicalize(String algorithm, List<AttributeNS> namespaceDecls) {
        throw new UnsupportedOperationException();
    }

    public boolean isCanonicalized() {
        throw new UnsupportedOperationException();
    }

    private Marshaller getMarshaller() throws JAXBException {
        return JAXBUtil.createMarshaller(this.soapVersion);
    }

    @Override
    public ReferenceList getReferenceList() {
        return this.ekt.getReferenceList();
    }

    public boolean hasReferenceList() {
        return this.ekt.getReferenceList() != null;
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        Object data;
        List<XMLStructure> list;
        KeyInfo ki = (KeyInfo)this.ekt.getKeyInfo();
        if (ki != null && (list = ki.getContent()).size() > 0 && (data = ((JAXBElement)list.get(0)).getValue()) instanceof SecurityHeaderElement && ((SecurityHeaderElement)data).refersToSecHdrWithId(id)) {
            return true;
        }
        list = null;
        if (this.getReferenceList() != null) {
            list = this.getReferenceList().getDataReferenceOrKeyReference();
        }
        if (list == null) {
            return false;
        }
        String idref = "#" + id;
        for (int i = 0; i < list.size(); ++i) {
            JAXBElement rt = (JAXBElement)list.get(i);
            ReferenceType ref = (ReferenceType)rt.getValue();
            if (!ref.getURI().equals(idref)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReferenceList(ReferenceList list) {
        this.ekt.setReferenceList(list);
    }

    @Override
    public Key getKey() {
        return this.dataEnckey;
    }

    public byte[] getCipherValue() {
        return this.dep.getCipherValueOfEK();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        try {
            Marshaller marshaller = this.getMarshaller();
            for (Map.Entry entry : props.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
            this.writeTo(streamWriter);
        }
        catch (JAXBException jbe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1921_ERROR_WRITING_ENCRYPTEDKEY(jbe.getMessage()), jbe);
            throw new XMLStreamException(jbe);
        }
    }

    @Override
    public boolean isFeatureSupported(String feature) {
        return false;
    }
}

