/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealGroupedAggregateStatistics
extends RealNoPutResultSetStatistics {
    public int rowsInput;
    public boolean hasDistinctAggregate;
    public boolean inSortedOrder;
    public ResultSetStatistics childResultSetStatistics;
    public Properties sortProperties;

    public RealGroupedAggregateStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, int n5, boolean bl, boolean bl2, Properties properties, double d, double d2, ResultSetStatistics resultSetStatistics) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.rowsInput = n5;
        this.hasDistinctAggregate = bl;
        this.inSortedOrder = bl2;
        this.childResultSetStatistics = resultSetStatistics;
        this.sortProperties = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.sortProperties.put(string, properties.get(string));
        }
    }

    @Override
    public String getStatementExecutionPlanText(int n) {
        this.initFormatInfo(n);
        String string = this.inSortedOrder ? "" : this.indent + MessageService.getTextMessage("43X40.U", new Object[0]) + ": \n" + PropertyUtil.sortProperties(this.sortProperties, this.subIndent);
        return this.indent + MessageService.getTextMessage("43X41.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X21.U", new Object[0]) + " = " + this.rowsInput + "\n" + this.indent + MessageService.getTextMessage("43X42.U", new Object[0]) + " = " + this.hasDistinctAggregate + "\n" + this.indent + MessageService.getTextMessage("43X43.U", new Object[0]) + " = " + this.inSortedOrder + "\n" + string + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X05.U", new Object[0]) + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String string, int n) {
        return this.childResultSetStatistics.getScanStatisticsText(string, n);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.childResultSetStatistics);
        return vector;
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X44.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.childResultSetStatistics != null) {
            ++n;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "GROUPBY";
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, null, null, (UUID)object2, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, this.rowsInput, this.rowsSeen, null, this.rowsFiltered, null, null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }

    @Override
    public Object getSortPropsDescriptor(Object object) {
        Properties properties = this.sortProperties;
        XPLAINSortPropsDescriptor xPLAINSortPropsDescriptor = new XPLAINSortPropsDescriptor((UUID)object, null, null, null, null, null, null, XPLAINUtil.getYesNoCharFromBoolean(this.inSortedOrder), XPLAINUtil.getYesNoCharFromBoolean(this.hasDistinctAggregate));
        return XPLAINUtil.extractSortProps(xPLAINSortPropsDescriptor, properties);
    }
}

