/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.jersey.model;

import jakarta.mvc.Controller;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;

public class KrazoModelProcessor
implements ModelProcessor {
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        ResourceModel.Builder rmb = new ResourceModel.Builder(false);
        resourceModel.getResources().forEach(r -> rmb.addResource(KrazoModelProcessor.processResource(r)));
        return rmb.build();
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return subResourceModel;
    }

    private static Resource processResource(Resource r) {
        boolean isControllerClass = KrazoModelProcessor.isController(r);
        Resource.Builder rb = Resource.builder((Resource)r);
        r.getAllMethods().forEach(m -> {
            if ((KrazoModelProcessor.isController(m) || isControllerClass) && m.getProducedTypes().isEmpty()) {
                ResourceMethod.Builder rmb = rb.updateMethod(m);
                rmb.produces(new MediaType[]{MediaType.TEXT_HTML_TYPE});
                rmb.build();
            }
        });
        r.getChildResources().forEach(cr -> rb.replaceChildResource(cr, KrazoModelProcessor.processResource(cr)));
        return rb.build();
    }

    private static boolean isController(ResourceMethod method) {
        return method.getInvocable().getDefinitionMethod().isAnnotationPresent(Controller.class);
    }

    private static boolean isController(Resource resource) {
        Boolean b1 = resource.getHandlerClasses().stream().map(c -> c.isAnnotationPresent(Controller.class)).reduce(Boolean.FALSE, Boolean::logicalOr);
        Boolean b2 = resource.getHandlerInstances().stream().map(o -> o.getClass().isAnnotationPresent(Controller.class)).reduce(Boolean.FALSE, Boolean::logicalOr);
        return b1 != false || b2 != false;
    }
}

