/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.unix;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.dispatch.DispatchTask;
import org.apache.tools.ant.dispatch.DispatchUtils;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.SymbolicLinkUtils;

public class Symlink
extends DispatchTask {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final SymbolicLinkUtils SYMLINK_UTILS = SymbolicLinkUtils.getSymbolicLinkUtils();
    private String resource;
    private String link;
    private Vector fileSets = new Vector();
    private String linkFileName;
    private boolean overwrite;
    private boolean failonerror;
    private boolean executing = false;

    @Override
    public void init() throws BuildException {
        super.init();
        this.setDefaults();
    }

    @Override
    public synchronized void execute() throws BuildException {
        if (this.executing) {
            throw new BuildException("Infinite recursion detected in Symlink.execute()");
        }
        try {
            this.executing = true;
            DispatchUtils.execute(this);
        }
        finally {
            this.executing = false;
        }
    }

    public void single() throws BuildException {
        try {
            if (this.resource == null) {
                this.handleError("Must define the resource to symlink to!");
                return;
            }
            if (this.link == null) {
                this.handleError("Must define the link name for symlink!");
                return;
            }
            this.doLink(this.resource, this.link);
        }
        finally {
            this.setDefaults();
        }
    }

    public void delete() throws BuildException {
        try {
            if (this.link == null) {
                this.handleError("Must define the link name for symlink!");
                return;
            }
            this.log("Removing symlink: " + this.link);
            SYMLINK_UTILS.deleteSymbolicLink(FILE_UTILS.resolveFile(new File("."), this.link), this);
        }
        catch (FileNotFoundException fnfe) {
            this.handleError(fnfe.toString());
        }
        catch (IOException ioe) {
            this.handleError(ioe.toString());
        }
        finally {
            this.setDefaults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreate() throws BuildException {
        try {
            if (this.fileSets.isEmpty()) {
                this.handleError("File set identifying link file(s) required for action recreate");
                return;
            }
            Properties links = this.loadLinks(this.fileSets);
            for (String string : links.keySet()) {
                String res = links.getProperty(string);
                try {
                    File test = new File(string);
                    if (!SYMLINK_UTILS.isSymbolicLink(string)) {
                        this.doLink(res, string);
                        continue;
                    }
                    if (test.getCanonicalPath().equals(new File(res).getCanonicalPath())) continue;
                    SYMLINK_UTILS.deleteSymbolicLink(test, this);
                    this.doLink(res, string);
                }
                catch (IOException ioe) {
                    this.handleError("IO exception while creating link");
                }
            }
        }
        finally {
            this.setDefaults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record() throws BuildException {
        try {
            if (this.fileSets.isEmpty()) {
                this.handleError("Fileset identifying links to record required");
                return;
            }
            if (this.linkFileName == null) {
                this.handleError("Name of file to record links in required");
                return;
            }
            Hashtable<File, Vector<File>> byDir = new Hashtable<File, Vector<File>>();
            for (File thisLink : this.findLinks(this.fileSets)) {
                File parent = thisLink.getParentFile();
                Vector<File> v = (Vector<File>)byDir.get(parent);
                if (v == null) {
                    v = new Vector<File>();
                    byDir.put(parent, v);
                }
                v.addElement(thisLink);
            }
            for (File dir : byDir.keySet()) {
                Vector linksInDir = (Vector)byDir.get(dir);
                Properties linksToStore = new Properties();
                for (File lnk : linksInDir) {
                    try {
                        linksToStore.put(lnk.getName(), lnk.getCanonicalPath());
                    }
                    catch (IOException ioe) {
                        this.handleError("Couldn't get canonical name of parent link");
                    }
                }
                this.writePropertyFile(linksToStore, dir);
            }
        }
        finally {
            this.setDefaults();
        }
    }

    private void setDefaults() {
        this.resource = null;
        this.link = null;
        this.linkFileName = null;
        this.failonerror = true;
        this.overwrite = false;
        this.setAction("single");
        this.fileSets.clear();
    }

    public void setOverwrite(boolean owrite) {
        this.overwrite = owrite;
    }

    public void setFailOnError(boolean foe) {
        this.failonerror = foe;
    }

    @Override
    public void setAction(String action) {
        super.setAction(action);
    }

    public void setLink(String lnk) {
        this.link = lnk;
    }

    public void setResource(String src) {
        this.resource = src;
    }

    public void setLinkfilename(String lf) {
        this.linkFileName = lf;
    }

    public void addFileset(FileSet set) {
        this.fileSets.addElement(set);
    }

    @Deprecated
    public static void deleteSymlink(String path) throws IOException {
        SYMLINK_UTILS.deleteSymbolicLink(new File(path), null);
    }

    @Deprecated
    public static void deleteSymlink(File linkfil) throws IOException {
        SYMLINK_UTILS.deleteSymbolicLink(linkfil, null);
    }

    private void writePropertyFile(Properties properties, File dir) throws BuildException {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(new File(dir, this.linkFileName)));
            properties.store(bos, "Symlinks from " + dir);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException(ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(bos);
                throw throwable;
            }
        }
        FileUtils.close(bos);
    }

    private void handleError(String msg) {
        if (this.failonerror) {
            throw new BuildException(msg);
        }
        this.log(msg);
    }

    private void doLink(String res, String lnk) throws BuildException {
        File linkfil = new File(lnk);
        String options = "-s";
        if (this.overwrite) {
            options = options + "f";
            if (linkfil.exists()) {
                try {
                    SYMLINK_UTILS.deleteSymbolicLink(linkfil, this);
                }
                catch (FileNotFoundException fnfe) {
                    this.log("Symlink disappeared before it was deleted: " + lnk);
                }
                catch (IOException ioe) {
                    this.log("Unable to overwrite preexisting link or file: " + lnk, ioe, 2);
                }
            }
        }
        String[] cmd = new String[]{"ln", options, res, lnk};
        try {
            Execute.runCommand(this, cmd);
        }
        catch (BuildException failedToExecute) {
            if (this.failonerror) {
                throw failedToExecute;
            }
            this.log(failedToExecute.getMessage(), failedToExecute, 2);
        }
    }

    private HashSet findLinks(Vector v) {
        HashSet<File> result = new HashSet<File>();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = (FileSet)v.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[][] fnd = new String[][]{ds.getIncludedFiles(), ds.getIncludedDirectories()};
            File dir = fs.getDir(this.getProject());
            for (int j = 0; j < fnd.length; ++j) {
                for (int k = 0; k < fnd[j].length; ++k) {
                    try {
                        File f = new File(dir, fnd[j][k]);
                        File pf = f.getParentFile();
                        String name = f.getName();
                        if (!SYMLINK_UTILS.isSymbolicLink(pf, name)) continue;
                        result.add(new File(pf.getCanonicalFile(), name));
                        continue;
                    }
                    catch (IOException e) {
                        this.handleError("IOException: " + fnd[j][k] + " omitted");
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private Properties loadLinks(Vector v) {
        Properties finalList = new Properties();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = (FileSet)v.elementAt(i);
            DirectoryScanner ds = new DirectoryScanner();
            fs.setupDirectoryScanner(ds, this.getProject());
            ds.setFollowSymlinks(false);
            ds.scan();
            String[] incs = ds.getIncludedFiles();
            File dir = fs.getDir(this.getProject());
            for (int j = 0; j < incs.length; ++j) {
                File inc = new File(dir, incs[j]);
                File pf = inc.getParentFile();
                Properties lnks = new Properties();
                BufferedInputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(inc));
                    lnks.load(is);
                    pf = pf.getCanonicalFile();
                }
                catch (FileNotFoundException fnfe) {
                    this.handleError("Unable to find " + incs[j] + "; skipping it.");
                    FileUtils.close(is);
                    continue;
                }
                catch (IOException ioe) {
                    this.handleError("Unable to open " + incs[j] + " or its parent dir; skipping it.");
                    {
                        catch (Throwable throwable) {
                            FileUtils.close(is);
                            throw throwable;
                        }
                    }
                    FileUtils.close(is);
                    continue;
                }
                FileUtils.close(is);
                lnks.list(new PrintStream(new LogOutputStream(this, 2)));
                for (String key : lnks.keySet()) {
                    finalList.put(new File(pf, key).getAbsolutePath(), lnks.getProperty(key));
                }
            }
        }
        return finalList;
    }
}

