/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt.report;

import java.io.BufferedWriter;
import java.io.IOException;
import org.jboss.logging.processor.apt.report.ReportType;
import org.jboss.logging.processor.apt.report.ReportWriter;
import org.jboss.logging.processor.model.LoggerMessageMethod;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class AsciidocReportWriter
extends ReportWriter {
    private final BufferedWriter writer;

    AsciidocReportWriter(MessageInterface messageInterface, BufferedWriter writer) {
        super(messageInterface);
        this.writer = writer;
    }

    @Override
    public void writeHeader(String title) throws IOException {
        String escapedTitle = title != null ? this.escape(title).toString() : "Messages";
        this.writer.write(escapedTitle);
        this.writer.newLine();
        for (int i = 0; i < escapedTitle.length(); ++i) {
            this.writer.append('=');
        }
        this.writer.newLine();
        this.writer.newLine();
        this.writer.append('.').append(this.messageInterface.name());
        this.writer.newLine();
        this.writer.write("[cols=\"1,5,^1,2m\"]");
        this.writer.newLine();
        this.writer.write("|===");
        this.writer.newLine();
        this.writer.write("|Message Id |Message |Log Level |Return Type");
        this.writer.newLine();
        this.writer.newLine();
    }

    @Override
    public void writeDetail(MessageMethod messageMethod) throws IOException {
        MessageMethod.Message msg = messageMethod.message();
        String id = msg.hasId() ? String.format(this.messageIdFormat, msg.id()) : "--";
        String url = this.getUrl(messageMethod, id);
        if (url.isEmpty()) {
            this.writer.append('|').append(this.escape(id));
        } else {
            this.writer.append("|link:").append(url).append('[').append(id).append(']');
        }
        this.writer.newLine();
        this.writer.append('|').append(this.escape(msg.value()));
        this.writer.newLine();
        if (messageMethod instanceof LoggerMessageMethod) {
            this.writer.append('|').append(this.getLogLevel((LoggerMessageMethod)messageMethod));
            this.writer.newLine();
            this.writer.append("|void");
        } else {
            this.writer.append("|--");
            this.writer.newLine();
            this.writer.append('|').append(messageMethod.returnType().name());
        }
        this.writer.newLine();
        this.writer.newLine();
    }

    @Override
    public void writeFooter() throws IOException {
        this.writer.write("|===");
        this.writer.newLine();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    ReportType getReportType() {
        return ReportType.ASCIIDOC;
    }

    private CharSequence escape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        int aPos = -1;
        int offset = 0;
        char previous = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '*': {
                    char next;
                    if (aPos >= 0) {
                        if (previous != ' ') {
                            sb.insert(aPos + offset++, '\\');
                        }
                        aPos = -1;
                        break;
                    }
                    if (i + 1 >= len || (next = s.charAt(i + 1)) == ' ') break;
                    aPos = i;
                }
            }
            previous = c;
            sb.append(c);
        }
        return sb;
    }
}

