/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.xmlfilter;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.xmlfilter.InvocationProcessingException;
import com.sun.xml.ws.xmlfilter.XmlStreamWriterMethodType;
import com.sun.xml.ws.xmlfilter.localization.LocalizationMessages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import javax.xml.stream.XMLStreamWriter;

public final class Invocation {
    private static final Logger LOGGER = Logger.getLogger(Invocation.class);
    private final Method method;
    private final Object[] arguments;
    private String argsString;
    private final XmlStreamWriterMethodType methodType;
    private final boolean returnsVoid;

    public static Invocation createInvocation(Method method, Object[] args) {
        Object[] arguments;
        XmlStreamWriterMethodType methodType = XmlStreamWriterMethodType.getMethodType(method.getName());
        if (methodType == XmlStreamWriterMethodType.WRITE_CHARACTERS && args.length == 3) {
            Integer start = (Integer)args[1];
            Integer length = (Integer)args[2];
            char[] charArrayCopy = new char[length.intValue()];
            System.arraycopy(args[0], start, charArrayCopy, 0, length);
            arguments = new Object[]{charArrayCopy, 0, length};
        } else {
            arguments = args;
        }
        return new Invocation(method, methodType, arguments);
    }

    public static void executeBatch(XMLStreamWriter target, Queue<Invocation> batch) throws InvocationProcessingException {
        for (Invocation invocation : batch) {
            if (invocation.returnsVoid) continue;
            throw (InvocationProcessingException)LOGGER.logSevereException((Throwable)new InvocationProcessingException("Cannot batch-execute invocation with non-void return type: '" + invocation.getMethodName() + "'"));
        }
        while (!batch.isEmpty()) {
            batch.poll().execute(target);
        }
    }

    private Invocation(Method method, XmlStreamWriterMethodType type, Object[] args) {
        this.method = method;
        this.arguments = args;
        this.methodType = type;
        this.returnsVoid = Void.TYPE.isAssignableFrom(method.getReturnType());
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public XmlStreamWriterMethodType getMethodType() {
        return this.methodType;
    }

    public Object getArgument(int index) throws ArrayIndexOutOfBoundsException {
        if (this.arguments == null) {
            throw (ArrayIndexOutOfBoundsException)LOGGER.logSevereException((Throwable)new ArrayIndexOutOfBoundsException(LocalizationMessages.XMLF_5019_NO_ARGUMENTS_IN_INVOCATION(this.toString())));
        }
        return this.arguments[index];
    }

    public int getArgumentsCount() {
        return this.arguments == null ? 0 : this.arguments.length;
    }

    public Object execute(XMLStreamWriter target) throws InvocationProcessingException {
        try {
            return this.method.invoke((Object)target, this.arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw (InvocationProcessingException)LOGGER.logSevereException((Throwable)new InvocationProcessingException(this, (Throwable)e));
        }
        catch (InvocationTargetException e) {
            throw (InvocationProcessingException)LOGGER.logSevereException((Throwable)new InvocationProcessingException(this, e.getCause()));
        }
    }

    public String toString() {
        return "invocation { method='" + this.method.getName() + "', args=" + this.argsToString() + "}";
    }

    public String argsToString() {
        if (this.argsString == null) {
            List<Object> argList = null;
            if (this.arguments != null && this.arguments.length > 0) {
                if (this.arguments.length == 3 && "writeCharacters".equals(this.method.getName())) {
                    argList = new ArrayList<Object>(3);
                    argList.add(new String((char[])this.arguments[0]));
                    argList.add(this.arguments[1]);
                    argList.add(this.arguments[2]);
                } else {
                    argList = Arrays.asList(this.arguments);
                }
            }
            this.argsString = argList == null ? "no arguments" : argList.toString();
        }
        return this.argsString;
    }
}

