/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

final class ConformUtils {
    private static final ConcurrentHashMap<Object, Pattern> patternCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Object, Pattern> regexpPatternCache = new ConcurrentHashMap();

    ConformUtils() {
    }

    static Boolean conformLike(Object left, Object right) {
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        left = String.valueOf(left);
        Pattern pattern = patternCache.get(right = String.valueOf(right));
        if (pattern == null) {
            String convertedRight = ConformUtils.convertLikeToRegex((String)right);
            pattern = Pattern.compile(convertedRight);
            if (patternCache.size() > 100) {
                patternCache.remove(((ConcurrentHashMap.KeySetView)patternCache.keySet()).iterator().next());
            }
            patternCache.put(right, pattern);
        }
        return pattern.matcher((String)left).matches();
    }

    static Boolean conformRegexp(Object left, Object right) {
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return Boolean.FALSE;
        }
        left = String.valueOf(left);
        Pattern pattern = regexpPatternCache.get(right = String.valueOf(right));
        if (pattern == null) {
            pattern = Pattern.compile((String)right);
            if (regexpPatternCache.size() > 100) {
                regexpPatternCache.remove(((ConcurrentHashMap.KeySetView)regexpPatternCache.keySet()).iterator().next());
            }
            regexpPatternCache.put(right, pattern);
        }
        return pattern.matcher((String)left).matches();
    }

    static String convertLikeToRegex(String like) {
        Object pattern = like.replaceAll("\\?", "\\\\?");
        pattern = ((String)pattern).replaceAll("\\*", "\\\\*");
        pattern = ((String)pattern).replaceAll("\\.", "\\\\.");
        pattern = ((String)pattern).replaceAll("\\[", "\\\\[");
        pattern = ((String)pattern).replaceAll("\\)", "\\\\)");
        pattern = ((String)pattern).replaceAll("\\(", "\\\\(");
        pattern = ((String)pattern).replaceAll("\\{", "\\\\{");
        pattern = ((String)pattern).replaceAll("\\+", "\\\\+");
        pattern = ((String)pattern).replaceAll("\\^", "\\\\^");
        pattern = ((String)pattern).replaceAll("\\|", "\\\\|");
        pattern = ((String)pattern).replaceAll("(?<!\\\\)%", ".*");
        pattern = ((String)pattern).replaceAll("(?<!\\\\)_", ".");
        pattern = ((String)pattern).replaceAll("\\\\%", "%");
        pattern = ((String)pattern).replaceAll("\\\\_", "_");
        pattern = "^" + (String)pattern + "$";
        return pattern;
    }
}

