/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.api;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.ha.store.util.KeyTransformer;
import org.glassfish.shoal.ha.cache.api.IdleEntryDetector;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.mapper.KeyMapper;
import org.glassfish.shoal.ha.cache.store.DataStoreEntryUpdater;

public class DataStoreConfigurator<K, V> {
    private String instanceName;
    private String groupName;
    private String storeName;
    private Class<K> keyClazz;
    private Class<V> valueClazz;
    private KeyMapper keyMapper;
    private boolean startGMS;
    private ClassLoader clazzLoader;
    private boolean cacheLocally;
    private boolean doSynchronousReplication;
    private List<Command<K, ? super V>> commands = new ArrayList<Command<K, ? super V>>();
    private boolean addCommands;
    private IdleEntryDetector<K, V> idleEntryDetector;
    private long defaultMaxIdleTimeInMillis = -1L;
    private DataStoreEntryUpdater<K, V> dseUpdater;
    private boolean safeToDelayCaptureState = true;
    private boolean useMapToCacheCommands = true;
    private KeyTransformer<K> keyTransformer;
    private boolean broadcastRemovedExpired = true;

    protected DataStoreConfigurator() {
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public DataStoreConfigurator<K, V> setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public DataStoreConfigurator<K, V> setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public DataStoreConfigurator<K, V> setStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public Class<K> getKeyClazz() {
        return this.keyClazz;
    }

    public DataStoreConfigurator<K, V> setKeyClazz(Class<K> kClazz) {
        this.keyClazz = kClazz;
        return this;
    }

    public Class<V> getValueClazz() {
        return this.valueClazz;
    }

    public DataStoreConfigurator<K, V> setValueClazz(Class<V> vClazz) {
        this.valueClazz = vClazz;
        return this;
    }

    public KeyMapper getKeyMapper() {
        return this.keyMapper;
    }

    public DataStoreConfigurator<K, V> setKeyMapper(KeyMapper keyMapper) {
        this.keyMapper = keyMapper;
        return this;
    }

    public boolean isStartGMS() {
        return this.startGMS;
    }

    public DataStoreConfigurator<K, V> setStartGMS(boolean startGMS) {
        this.startGMS = startGMS;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.clazzLoader;
    }

    public DataStoreConfigurator<K, V> setClassLoader(ClassLoader loader) {
        this.clazzLoader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        return this;
    }

    public boolean isCacheLocally() {
        return this.cacheLocally;
    }

    public DataStoreConfigurator<K, V> setCacheLocally(boolean cacheLocally) {
        this.cacheLocally = cacheLocally;
        return this;
    }

    public boolean isDoSynchronousReplication() {
        return this.doSynchronousReplication;
    }

    public DataStoreConfigurator<K, V> setDoSynchronousReplication(boolean val) {
        this.doSynchronousReplication = val;
        return this;
    }

    public List<Command<K, ? super V>> getCommands() {
        return this.commands;
    }

    public void addCommand(Command<K, V> cmd) {
        this.commands.add(cmd);
    }

    public DataStoreConfigurator<K, V> setDoAddCommands() {
        this.addCommands = true;
        return this;
    }

    public boolean isDoAddCommands() {
        return this.addCommands;
    }

    public IdleEntryDetector<K, V> getIdleEntryDetector() {
        return this.idleEntryDetector;
    }

    public DataStoreConfigurator<K, V> setIdleEntryDetector(IdleEntryDetector<K, V> idleEntryDetector) {
        this.idleEntryDetector = idleEntryDetector;
        return this;
    }

    public long getDefaultMaxIdleTimeInMillis() {
        return this.defaultMaxIdleTimeInMillis;
    }

    public DataStoreConfigurator<K, V> setDefaultMaxIdleTimeInMillis(long defaultMaxIdleTimeInMillis) {
        this.defaultMaxIdleTimeInMillis = defaultMaxIdleTimeInMillis;
        return this;
    }

    public DataStoreEntryUpdater<K, V> getDataStoreEntryUpdater() {
        return this.dseUpdater;
    }

    public DataStoreConfigurator<K, V> setDataStoreEntryUpdater(DataStoreEntryUpdater<K, V> dseUpdater) {
        this.dseUpdater = dseUpdater;
        return this;
    }

    public boolean isSafeToDelayCaptureState() {
        return this.safeToDelayCaptureState;
    }

    public DataStoreConfigurator<K, V> setSafeToDelayCaptureState(boolean safeToDelayCaptureState) {
        this.safeToDelayCaptureState = safeToDelayCaptureState;
        return this;
    }

    public boolean isUseMapToCacheCommands() {
        return this.useMapToCacheCommands;
    }

    public DataStoreConfigurator<K, V> setUseMapToCacheCommands(boolean useMapToCacheCommands) {
        this.useMapToCacheCommands = useMapToCacheCommands;
        return this;
    }

    public KeyTransformer<K> getKeyTransformer() {
        return this.keyTransformer;
    }

    public DataStoreConfigurator<K, V> setKeyTransformer(KeyTransformer<K> keyTransformer) {
        this.keyTransformer = keyTransformer;
        return this;
    }

    public boolean isBroadcastRemovedExpired() {
        return this.broadcastRemovedExpired;
    }

    public DataStoreConfigurator<K, V> setBroadcastRemovedExpired(boolean broadcastRemovedExpired) {
        this.broadcastRemovedExpired = broadcastRemovedExpired;
        return this;
    }

    public String toString() {
        return "DataStoreConfigurator{instanceName='" + this.instanceName + "', groupName='" + this.groupName + "', storeName='" + this.storeName + "', keyClazz=" + String.valueOf(this.keyClazz) + ", valueClazz=" + String.valueOf(this.valueClazz) + ", keyMapper=" + String.valueOf(this.keyMapper) + ", startGMS=" + this.startGMS + ", cacheLocally= " + this.cacheLocally + ", clazzLoader=" + String.valueOf(this.clazzLoader) + ", doSynchronousReplication=" + this.doSynchronousReplication + ", broadcastRemovedExpired=" + this.broadcastRemovedExpired + ", keyTransformer=" + (this.keyTransformer == null ? null : this.keyTransformer.getClass().getName()) + "}";
    }
}

