/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.store.DataStoreEntry;
import org.glassfish.shoal.ha.cache.store.backing.commands.AbstractSaveCommand;

public class SaveCommand<K, V>
extends AbstractSaveCommand<K, V> {
    private static final long serialVersionUID = -1681470355087702983L;
    private transient V v;
    private transient byte[] rawV;

    public SaveCommand() {
        super((byte)33);
    }

    public SaveCommand(K k, V v, long version, long lastAccessedAt, long maxIdleTime) {
        super((byte)33, k, version, lastAccessedAt, maxIdleTime);
        this.v = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + this.getName() + " received save_command for key = " + String.valueOf(this.getKey()) + " from " + initiator + "; version = " + this.getVersion());
        }
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.getKey());
        synchronized (dataStoreEntry) {
            this.dsc.getDataStoreEntryUpdater().executeSave(entry, this);
        }
        if (this.dsc.isDoSynchronousReplication()) {
            _logger.log(Level.FINE, "SaveCommand Sending SIMPLE_ACK");
            super.sendAcknowledgement();
        }
        this.dsc.getDataStoreMBean().incrementExecutedSaveCount();
    }

    @Override
    public String toString() {
        return this.getName() + "(" + String.valueOf(this.getKey()) + ")";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.rawV = this.dsc.getDataStoreEntryUpdater().getState(this.v);
        out.writeObject(this.rawV);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getServiceName() + " sending save_command for key = " + String.valueOf(this.getKey()) + "; version = " + this.version + "; lastAccessedAt = " + this.lastAccessedAt + "; to " + this.getTargetName());
        }
    }

    @Override
    public boolean hasState() {
        return true;
    }

    public byte[] getRawV() {
        return this.rawV;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.rawV = (byte[])in.readObject();
    }
}

