/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.glassfish.shoal.ha.cache.util.Utility;

public class ReplicationOutputStream
extends ByteArrayOutputStream {
    private int maxCount;

    public int mark() {
        return this.size();
    }

    public void reWrite(int mark, byte[] data) {
        System.arraycopy(data, 0, this.buf, mark, data.length);
    }

    public void writeInt(int value) throws IOException {
        this.write(Utility.intToBytes(value));
    }

    public void writeLong(long value) throws IOException {
        this.write(Utility.longToBytes(value));
    }

    public void writeLengthPrefixedString(String str) throws IOException {
        if (str == null) {
            this.writeInt(0);
        } else {
            byte[] data = str.getBytes(Charset.defaultCharset());
            this.writeInt(data.length);
            this.write(data);
        }
    }

    public void writeLengthPrefixedBytes(byte[] data) throws IOException {
        if (data == null) {
            this.writeInt(0);
        } else {
            this.writeInt(data.length);
            this.write(data);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    public int moveTo(int pos) {
        if (this.count > this.maxCount) {
            this.maxCount = this.count;
        }
        int oldPos = this.count;
        if (pos >= 0 && pos <= this.count) {
            this.count = pos;
        }
        return oldPos;
    }

    public void backToAppendMode() {
        if (this.count < this.maxCount) {
            this.count = this.maxCount;
        }
    }

    @Override
    public byte[] toByteArray() {
        this.backToAppendMode();
        return super.toByteArray();
    }
}

