/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.tx.at.common.TransactionImportWrapper;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import jakarta.resource.spi.XATerminator;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionImportManager
implements TransactionImportWrapper {
    private static final Logger LOGGER = Logger.getLogger(TransactionImportManager.class);
    private static TransactionImportManager INSTANCE;
    private static TransactionManager javaeeTM;
    private final MethodInfo<?> recreate;
    private final MethodInfo<?> release;
    private final MethodInfo<XATerminator> getXATerminator;
    private final MethodInfo<Integer> getTransactionRemainingTimeout;
    private final MethodInfo<String> getTxLogLocation;
    private static MethodInfo<?> registerRecoveryResourceHandler;

    public static TransactionImportManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TransactionImportManager();
        }
        return INSTANCE;
    }

    private TransactionImportManager() {
        this(TransactionManagerImpl.getInstance().getTransactionManager());
    }

    private TransactionImportManager(TransactionManager tm) {
        javaeeTM = tm;
        this.recreate = new MethodInfo<Void>("recreate", new Class[]{Xid.class, Long.TYPE}, Void.TYPE);
        this.release = new MethodInfo<Void>("release", new Class[]{Xid.class}, Void.TYPE);
        this.getXATerminator = new MethodInfo<XATerminator>("getXATerminator", new Class[0], XATerminator.class);
        this.getTransactionRemainingTimeout = new MethodInfo<Integer>("getTransactionRemainingTimeout", new Class[0], Integer.TYPE, Integer.class);
        this.getTxLogLocation = new MethodInfo<String>("getTxLogLocation", new Class[0], String.class);
        registerRecoveryResourceHandler = new MethodInfo<Void>("registerRecoveryResourceHandler", new Class[]{XAResource.class}, Void.TYPE);
        MethodInfo[] requiredMethods = new MethodInfo[]{this.recreate, this.release, this.getXATerminator, this.getTransactionRemainingTimeout, this.getTxLogLocation, registerRecoveryResourceHandler};
        int remainingMethodsToFind = requiredMethods.length;
        if (javaeeTM != null) {
            for (Method m : javaeeTM.getClass().getDeclaredMethods()) {
                for (MethodInfo mi : requiredMethods) {
                    if (!mi.isCompatibleWith(m)) continue;
                    mi.method = m;
                    --remainingMethodsToFind;
                }
                if (remainingMethodsToFind == 0) break;
            }
        }
        if (remainingMethodsToFind != 0) {
            StringBuilder sb = new StringBuilder("Missing required extension methods detected on '" + TransactionManager.class.getName() + "' implementation '" + javaeeTM.getClass().getName() + "':\n");
            for (MethodInfo mi : requiredMethods) {
                if (mi.method != null) continue;
                sb.append(mi.methodName).append("\n");
            }
            LOGGER.info(sb.toString());
        }
    }

    @Override
    public void recreate(Xid xid, long timeout) {
        this.recreate.invoke(javaeeTM, xid, timeout);
    }

    @Override
    public void release(Xid xid) {
        this.release.invoke(javaeeTM, xid);
    }

    @Override
    public XATerminator getXATerminator() {
        return this.getXATerminator.invoke(javaeeTM, new Object[0]);
    }

    @Override
    public int getTransactionRemainingTimeout() {
        String METHOD = "getTransactionRemainingTimeout";
        int result = 0;
        try {
            result = this.getTransactionRemainingTimeout.invoke(javaeeTM, new Object[0]);
        }
        catch (IllegalStateException ise) {
            LOGGER.finest("getTransactionRemainingTimeout " + LocalizationMessages.WSAT_4617_TXN_MGR_LOOKUP_TXN_TIMEOUT(), (Throwable)ise);
        }
        return result;
    }

    public String getTxLogLocation() {
        return this.getTxLogLocation.invoke(javaeeTM, new Object[0]);
    }

    public void registerRecoveryResourceHandler(XAResource xaResource) {
        registerRecoveryResourceHandler.invoke(javaeeTM, xaResource);
    }

    private static final class MethodInfo<T> {
        final String methodName;
        final Class<?>[] parameterTypes;
        final Class<?> returnType;
        final Class<T> returnTypeCaster;
        Method method;

        public MethodInfo(String methodName, Class<?>[] parameterTypes, Class<T> returnType) {
            this(methodName, parameterTypes, returnType, returnType);
        }

        public MethodInfo(String methodName, Class<?>[] parameterTypes, Class<?> returnType, Class<T> returnTypeCaster) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
            this.returnTypeCaster = returnTypeCaster;
        }

        public boolean isCompatibleWith(Method m) {
            if (!this.methodName.equals(m.getName())) {
                return false;
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                return false;
            }
            if (!this.returnType.isAssignableFrom(m.getReturnType())) {
                return false;
            }
            Class<?>[] otherParamTypes = m.getParameterTypes();
            if (this.parameterTypes.length != otherParamTypes.length) {
                return false;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                if (this.parameterTypes[i].isAssignableFrom(otherParamTypes[i])) continue;
                return false;
            }
            return true;
        }

        public T invoke(TransactionManager tmInstance, Object ... args) {
            try {
                Object result = this.method.invoke((Object)tmInstance, args);
                return this.returnTypeCaster.cast(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

