/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessStreamDrainerWorker;

public class ProcessStreamDrainer {
    private final ProcessStreamDrainerWorker outWorker;
    private final ProcessStreamDrainerWorker errWorker;
    private final Thread errThread;
    private final Thread outThread;
    private final boolean redirectStandardStreams;
    private static final String ERROR_DRAINER = "StderrDrainer";
    private static final String OUT_DRAINER = "StdoutDrainer";

    public static ProcessStreamDrainer drain(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, false, false);
        psd.drain();
        return psd;
    }

    public static ProcessStreamDrainer save(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, false, true);
        psd.drain();
        return psd;
    }

    public static ProcessStreamDrainer redirect(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, true, false);
        psd.drain();
        return psd;
    }

    public static ProcessStreamDrainer dispose(String processName, Process process) {
        ProcessStreamDrainer psd = new ProcessStreamDrainer(processName, process, false, false);
        psd.drain();
        return psd;
    }

    public final void waitFor() throws InterruptedException {
        this.errThread.join();
        this.outThread.join();
    }

    public final String getOutString() {
        return this.outWorker.getString();
    }

    public final String getErrString() {
        return this.errWorker.getString();
    }

    public final String getOutErrString() {
        return this.outWorker.getString() + this.errWorker.getString();
    }

    private ProcessStreamDrainer(String processName, Process process, boolean redirect, boolean save) {
        if (process == null) {
            throw new NullPointerException("Internal Error: null Process object");
        }
        if (processName == null || processName.length() <= 0) {
            processName = "UnknownProcessName";
        }
        this.redirectStandardStreams = redirect;
        this.outWorker = this.redirectStandardStreams ? new ProcessStreamDrainerWorker(process.getInputStream(), System.out, save) : new ProcessStreamDrainerWorker(process.getInputStream(), null, save);
        this.outThread = new Thread((Runnable)this.outWorker, processName + "-StdoutDrainer");
        this.outThread.setDaemon(true);
        this.errWorker = this.redirectStandardStreams ? new ProcessStreamDrainerWorker(process.getErrorStream(), System.err, save) : new ProcessStreamDrainerWorker(process.getErrorStream(), null, save);
        this.errThread = new Thread((Runnable)this.errWorker, processName + "-StderrDrainer");
        this.errThread.setDaemon(true);
    }

    private void drain() {
        this.outThread.start();
        this.errThread.start();
    }
}

