/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.valuecontext;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.engine.path.MutablePath;
import org.hibernate.validator.internal.engine.valuecontext.ValueContext;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;

public final class BeanValueContext<T, V>
extends ValueContext<T, V> {
    private BeanMetaData<?> currentBeanMetaData;
    private Set<Class<?>> alreadyProcessedGroups;
    private Map<MetaConstraint<?>, Boolean> alreadyProcessedMetaConstraints;

    BeanValueContext(ValueContext<?, ?> parentContext, ExecutableParameterNameProvider parameterNameProvider, T currentBean, BeanMetaData<T> currentBeanMetaData, MutablePath propertyPath) {
        super(parentContext, parameterNameProvider, currentBean, currentBeanMetaData, propertyPath);
        this.currentBeanMetaData = currentBeanMetaData;
    }

    public BeanMetaData<T> getCurrentBeanMetaData() {
        return this.currentBeanMetaData;
    }

    public void reset(Object currentBean, MutablePath propertyPath, BeanMetaData<?> currentBeanMetaData) {
        this.currentBeanMetaData = currentBeanMetaData;
        this.currentValidatable = currentBeanMetaData;
        this.currentBean = currentBean;
        this.propertyPath = propertyPath;
        this.alreadyProcessedGroups = null;
        this.alreadyProcessedMetaConstraints = null;
        this.currentGroup = null;
        this.previousGroup = null;
    }

    @Override
    public boolean isBeanAlreadyValidated(Object value, Class<?> group) {
        ValueContext curr = this;
        while (curr != null) {
            if (curr.currentBean == value) {
                return ((ValueContext)curr).isProcessedForGroup(group);
            }
            curr = curr.parentContext;
        }
        return false;
    }

    @Override
    public void markCurrentGroupAsProcessed() {
        if (this.previousGroup != null && this.previousGroup != this.currentGroup) {
            if (this.alreadyProcessedGroups == null) {
                this.alreadyProcessedGroups = new HashSet();
                this.alreadyProcessedGroups.add(this.previousGroup);
            }
            this.alreadyProcessedGroups.add(this.currentGroup);
        }
    }

    @Override
    protected boolean isProcessedForGroup(Class<?> group) {
        return group == this.currentGroup || this.alreadyProcessedGroups != null && this.alreadyProcessedGroups.contains(group);
    }

    @Override
    public void markConstraintProcessed(MetaConstraint<?> metaConstraint) {
        if (this.alreadyProcessedMetaConstraints == null) {
            this.alreadyProcessedMetaConstraints = new IdentityHashMap();
        }
        this.alreadyProcessedMetaConstraints.put(metaConstraint, Boolean.TRUE);
    }

    @Override
    public boolean hasMetaConstraintBeenProcessed(MetaConstraint<?> metaConstraint) {
        return this.alreadyProcessedMetaConstraints != null && this.alreadyProcessedMetaConstraints.containsKey(metaConstraint);
    }
}

