/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import jakarta.resource.spi.security.PasswordCredential;
import java.util.Objects;
import org.glassfish.security.common.UserNameAndPassword;

public class ResourcePrincipalDescriptor
extends PrincipalNameDescriptor {
    private static final long serialVersionUID = 1L;
    private final String password;

    public static ResourcePrincipalDescriptor from(UserNameAndPassword principal) {
        return new ResourcePrincipalDescriptor(principal.getName(), principal.getStringPassword());
    }

    public ResourcePrincipalDescriptor(String name, String password) {
        super(name);
        this.password = password;
    }

    public final String getPassword() {
        return this.password;
    }

    public final boolean hasPassword() {
        return this.password != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ResourcePrincipalDescriptor) {
            ResourcePrincipalDescriptor other = (ResourcePrincipalDescriptor)((Object)o);
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.password, other.password);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.password);
    }

    public UserNameAndPassword toPrincipalNameAndPassword() {
        return new UserNameAndPassword(this.getName(), this.password);
    }

    public PasswordCredential toPasswordCredential() {
        if (this.password == null) {
            return null;
        }
        return new PasswordCredential(this.getName(), this.password.toCharArray());
    }
}

