/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.embeddable.GlassFishVariable;

public class RepositoryConfig
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final String K_INSTALL_ROOT = "install.root";
    public static final String K_CONFIG_ROOT = "config.root";
    public static final String K_REFRESH_CONFIG_CONTEXT = "refresh.cc";
    private final String _repositoryName;
    private String _repositoryRoot;
    private String _instanceName;
    private String _configurationName;

    public RepositoryConfig(String repositoryName, String repositoryRoot, String instanceName, String configName) {
        this._instanceName = instanceName;
        this._repositoryName = repositoryName;
        this._repositoryRoot = repositoryRoot;
        this._configurationName = configName;
        Map<String, String> envProperties = this.getEnvProps();
        this.put(K_REFRESH_CONFIG_CONTEXT, true);
        if (envProperties != null) {
            this.put(K_INSTALL_ROOT, envProperties.get(GlassFishVariable.INSTALL_ROOT.getPropertyName()));
            this.put(K_CONFIG_ROOT, envProperties.get(GlassFishVariable.CONFIG_ROOT.getPropertyName()));
        }
    }

    public RepositoryConfig(String repositoryName, String repositoryRoot, String instanceName) {
        this(repositoryName, repositoryRoot, instanceName, null);
    }

    public RepositoryConfig(String repositoryName, String repositoryRoot) {
        this(repositoryName, repositoryRoot, null);
    }

    public RepositoryConfig() {
        this(System.getProperty(GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName()));
    }

    public RepositoryConfig(String instanceRootString) {
        File instanceRoot = new File(instanceRootString);
        File repositoryDir = instanceRoot.getParentFile();
        this._instanceName = instanceRoot.getName();
        this._repositoryName = repositoryDir.getName();
        this._repositoryRoot = FileUtils.makeForwardSlashes((String)repositoryDir.getParentFile().getAbsolutePath());
        this._configurationName = null;
        Map<String, String> envProperties = this.getEnvProps();
        if (envProperties != null) {
            this.put(K_INSTALL_ROOT, envProperties.get(GlassFishVariable.INSTALL_ROOT.getPropertyName()));
            this.put(K_CONFIG_ROOT, envProperties.get(GlassFishVariable.CONFIG_ROOT.getPropertyName()));
        }
    }

    @Override
    public String toString() {
        return "repositoryRoot " + this._repositoryRoot + " repositoryName " + this._repositoryName + " instanceName " + this._instanceName + " configurationName " + this._configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this._configurationName = configurationName;
    }

    public String getConfigurationName() {
        return this._configurationName;
    }

    public String getDisplayName() {
        return this.getRepositoryName();
    }

    public void setInstanceName(String instanceName) {
        this._instanceName = instanceName;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    protected void setRepositoryRoot(String repositoryRoot) {
        this._repositoryRoot = repositoryRoot;
    }

    public String getRepositoryRoot() {
        return this._repositoryRoot;
    }

    public String getInstallRoot() {
        return (String)this.get(K_INSTALL_ROOT);
    }

    public String getConfigRoot() {
        return (String)this.get(K_CONFIG_ROOT);
    }

    public Boolean getRefreshConfigContext() {
        return (Boolean)this.get(K_REFRESH_CONFIG_CONTEXT);
    }

    public void setRefreshConfingContext(boolean refresh) {
        this.put(K_REFRESH_CONFIG_CONTEXT, refresh);
    }

    private Map<String, String> getEnvProps() {
        ASenvPropertyReader pr = new ASenvPropertyReader();
        return pr.getProps();
    }
}

