/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.shared.common.error.ErrorStringBuilder;
import org.apache.derby.shared.common.error.ExceptionFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public abstract class Util {
    private static int logSeverityLevel = PropertyUtil.getSystemInt("derby.stream.error.logSeverityLevel", 40000);

    public static void logAndThrowSQLException(SQLException sQLException) throws SQLException {
        if (sQLException.getErrorCode() >= logSeverityLevel) {
            Util.logSQLException(sQLException);
        }
        throw sQLException;
    }

    public static void logSQLException(SQLException sQLException) {
        if (sQLException == null) {
            return;
        }
        String string = sQLException.getMessage();
        String string2 = sQLException.getSQLState();
        if (string2 != null && string2.equals("08004") && string != null && string.equals("Connection refused : java.lang.OutOfMemoryError")) {
            return;
        }
        Util.logError("\nERROR " + sQLException.getSQLState() + ": " + sQLException.getMessage() + "\n", sQLException);
    }

    private static void logError(String string, Throwable throwable) {
        HeaderPrintWriter headerPrintWriter = Monitor.getStream();
        if (headerPrintWriter == null) {
            throwable.printStackTrace();
            return;
        }
        ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(headerPrintWriter.getHeader());
        errorStringBuilder.append(string);
        errorStringBuilder.stackTrace(throwable);
        headerPrintWriter.print(errorStringBuilder.get().toString());
        headerPrintWriter.flush();
        errorStringBuilder.reset();
    }

    public static void ASSERT(EmbedConnection embedConnection, boolean bl, String string) throws SQLException {
    }

    public static void checkForSupportedDataType(int n) throws SQLException {
        if (!Util.isSupportedType(n)) {
            throw Util.generateCsSQLException("0A000.S.7", Util.typeName(n));
        }
    }

    public static void checkSupportedRaiseStandard(int n) throws StandardException {
        if (!Util.isSupportedType(n)) {
            throw StandardException.newException("0A000.S.7", Util.typeName(n));
        }
    }

    private static boolean isSupportedType(int n) {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 0: 
            case 70: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: 
            case 2011: 
            case 2012: {
                return false;
            }
        }
        return true;
    }

    public static SQLException generateCsSQLException(String string, Object ... objectArray) {
        return Util.generateCsSQLException(string, null, objectArray);
    }

    static SQLException generateCsSQLException(String string, Throwable throwable, Object ... objectArray) {
        return ExceptionFactory.getInstance().getSQLException(string, (SQLException)null, throwable, objectArray);
    }

    public static SQLException generateCsSQLException(StandardException standardException) {
        return ExceptionFactory.getInstance().getSQLException(standardException.getMessage(), standardException.getMessageId(), null, standardException.getSeverity(), standardException, standardException.getArguments());
    }

    public static SQLException noCurrentConnection() {
        return Util.generateCsSQLException("08003", new Object[0]);
    }

    static SQLException seeNextException(String string, SQLException sQLException, Throwable throwable, Object ... objectArray) {
        return ExceptionFactory.getInstance().getSQLException(string, sQLException, throwable, objectArray);
    }

    public static SQLException javaException(Throwable throwable) {
        SQLException sQLException;
        String string = throwable.getMessage();
        if (string == null) {
            string = "";
        }
        String string2 = throwable.getClass().getName();
        SQLException sQLException2 = null;
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            sQLException2 = throwable2 instanceof SQLException ? (SQLException)throwable2 : (throwable2 instanceof StandardException ? Util.generateCsSQLException((StandardException)throwable2) : Util.javaException(throwable2));
        }
        if ((sQLException = Util.seeNextException("XJ001.U", sQLException2, throwable, string2, string)).getErrorCode() >= logSeverityLevel) {
            Util.logSQLException(sQLException);
        }
        return sQLException;
    }

    public static SQLException notImplemented() {
        return Util.notImplemented(MessageService.getTextMessage("J008", new Object[0]));
    }

    public static SQLException notImplemented(String string) {
        return Util.generateCsSQLException("0A000.S", string);
    }

    static SQLException setStreamFailure(IOException iOException) {
        String string = iOException.getMessage();
        if (string == null) {
            string = iOException.getClass().getName();
        }
        return Util.generateCsSQLException("XJ022.S", iOException, string);
    }

    static SQLException typeMisMatch(int n) {
        return Util.generateCsSQLException("XJ020.S", Util.typeName(n));
    }

    public static int[] squashLongs(long[] lArray) {
        int n = lArray == null ? 0 : lArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    static IOException newIOException(Throwable throwable) {
        return new IOException(throwable);
    }

    public static String typeName(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -7: {
                return "CHAR () FOR BIT DATA";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 70: {
                return "DATALINK";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case 2006: {
                return "REF";
            }
            case 2012: {
                return "REF CURSOR";
            }
            case -8: {
                return "ROWID";
            }
            case 2002: {
                return "STRUCT";
            }
            case 456: {
                return "XML";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return String.valueOf(n);
    }
}

