/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.rts.RealDeleteResultSetStatistics;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public class RealDeleteCascadeResultSetStatistics
extends RealDeleteResultSetStatistics {
    private ResultSetStatistics[] dependentTrackingArray;

    public RealDeleteCascadeResultSetStatistics(int n, boolean bl, int n2, boolean bl2, long l, ResultSetStatistics resultSetStatistics, ResultSetStatistics[] resultSetStatisticsArray) {
        super(n, bl, n2, bl2, l, resultSetStatistics);
        this.dependentTrackingArray = ArrayUtil.copy(resultSetStatisticsArray);
    }

    @Override
    public String getStatementExecutionPlanText(int n) {
        Object object = "";
        this.initFormatInfo(n);
        if (this.dependentTrackingArray != null) {
            boolean bl = false;
            for (int i = 0; i < this.dependentTrackingArray.length; ++i) {
                if (this.dependentTrackingArray[i] == null) continue;
                if (!bl) {
                    object = this.indent + "\n" + MessageService.getTextMessage("43Y53.U", new Object[0]) + ":\n";
                    bl = true;
                }
                object = (String)object + this.dependentTrackingArray[i].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        return this.indent + MessageService.getTextMessage("43Y52.U", new Object[0]) + " " + MessageService.getTextMessage(this.tableLock ? "43X14.U" : "43X15.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X16.U", new Object[0]) + ": " + this.deferred + "\n" + this.indent + MessageService.getTextMessage("43X17.U", new Object[0]) + " = " + this.rowCount + "\n" + this.indent + MessageService.getTextMessage("43X18.U", new Object[0]) + " = " + this.indexesUpdated + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getStatementExecutionPlanText(1)) + (String)object;
    }

    @Override
    public String getScanStatisticsText(String string, int n) {
        Object object = "";
        if (this.dependentTrackingArray != null) {
            for (int i = 0; i < this.dependentTrackingArray.length; ++i) {
                if (this.dependentTrackingArray[i] == null) continue;
                object = (String)object + "\n" + MessageService.getTextMessage("43Y54.U", new Object[0]) + " " + i + "\n" + this.dependentTrackingArray[i].getScanStatisticsText(string, n) + MessageService.getTextMessage("43Y55.U", new Object[0]) + " " + i + "\n\n";
            }
        }
        return (String)object + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getScanStatisticsText(string, n));
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43Y51.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.sourceResultSetStatistics != null) {
            ++n;
        }
        if (this.dependentTrackingArray != null) {
            n += this.dependentTrackingArray.length;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.sourceResultSetStatistics != null) {
            this.sourceResultSetStatistics.accept(xPLAINVisitor);
        }
        if (this.dependentTrackingArray != null) {
            boolean bl = false;
            for (int i = 0; i < this.dependentTrackingArray.length; ++i) {
                if (this.dependentTrackingArray[i] == null) continue;
                this.dependentTrackingArray[i].accept(xPLAINVisitor);
            }
        }
    }

    @Override
    public String getRSXplainDetails() {
        return "CASCADE";
    }
}

