/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheIsolationType;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.annotations.DatabaseChangeNotificationType;
import org.eclipse.persistence.descriptors.CacheIndex;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.interceptors.CacheInterceptor;

public class CachePolicy
implements Cloneable,
Serializable {
    protected Class<? extends IdentityMap> identityMapClass;
    protected int identityMapSize = -1;
    protected boolean shouldAlwaysRefreshCache;
    protected boolean shouldOnlyRefreshCacheIfNewerVersion;
    protected boolean shouldDisableCacheHits;
    protected Class<? extends IdentityMap> remoteIdentityMapClass;
    protected int remoteIdentityMapSize = -1;
    protected boolean shouldAlwaysRefreshCacheOnRemote;
    protected boolean shouldDisableCacheHitsOnRemote;
    private Boolean cacheable = null;
    protected CacheIsolationType cacheIsolation;
    protected int cacheSynchronizationType = 0;
    public static final int UNDEFINED_OBJECT_CHANGE_BEHAVIOR = 0;
    public static final int SEND_OBJECT_CHANGES = 1;
    public static final int INVALIDATE_CHANGED_OBJECTS = 2;
    public static final int SEND_NEW_OBJECTS_WITH_CHANGES = 3;
    public static final int DO_NOT_SEND_CHANGES = 4;
    protected int unitOfWorkCacheIsolationLevel = -1;
    protected boolean wasDefaultUnitOfWorkCacheIsolationLevel;
    public static final int UNDEFINED_ISOLATATION = -1;
    public static final int USE_SESSION_CACHE_AFTER_TRANSACTION = 0;
    public static final int ISOLATE_NEW_DATA_AFTER_TRANSACTION = 1;
    public static final int ISOLATE_CACHE_AFTER_TRANSACTION = 2;
    public static final int ISOLATE_FROM_CLIENT_SESSION = 3;
    public static final int ISOLATE_CACHE_ALWAYS = 4;
    protected CacheKeyType cacheKeyType;
    protected Class<? extends CacheInterceptor> cacheInterceptorClass;
    protected String cacheInterceptorClassName;
    protected boolean fullyMergeEntity;
    protected boolean prefetchCacheKeys;
    protected Map<List<DatabaseField>, CacheIndex> cacheIndexes;
    protected DatabaseChangeNotificationType databaseChangeNotificationType;

    public DatabaseChangeNotificationType getDatabaseChangeNotificationType() {
        return this.databaseChangeNotificationType;
    }

    public void setDatabaseChangeNotificationType(DatabaseChangeNotificationType databaseChangeNotificationType) {
        this.databaseChangeNotificationType = databaseChangeNotificationType;
    }

    public void initializeFromParent(CachePolicy parentPolicy, ClassDescriptor descriptor, ClassDescriptor descriptorDescriptor, AbstractSession session) throws DescriptorException {
        if (!parentPolicy.isSharedIsolation()) {
            boolean copyParrent;
            boolean bl = copyParrent = this.cacheable == null || this.cacheable == false;
            if (!this.isIsolated() && this.getCacheIsolation() != parentPolicy.getCacheIsolation() && copyParrent) {
                session.log(6, "metadata", "overriding_cache_isolation", new Object[]{descriptorDescriptor.getAlias(), parentPolicy.getCacheIsolation(), descriptor.getAlias(), this.getCacheIsolation()});
                this.setCacheIsolation(parentPolicy.getCacheIsolation());
            }
        }
        for (CacheIndex index : parentPolicy.getCacheIndexes().values()) {
            this.addCacheIndex(index);
        }
        if (this.getDatabaseChangeNotificationType() == null && parentPolicy.getDatabaseChangeNotificationType() != null) {
            this.setDatabaseChangeNotificationType(parentPolicy.getDatabaseChangeNotificationType());
        }
        if (this.getCacheSynchronizationType() == 0 && parentPolicy.getCacheSynchronizationType() != 0) {
            this.setCacheSynchronizationType(parentPolicy.getCacheSynchronizationType());
        }
    }

    public void postInitialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        if (!this.isSharedIsolation()) {
            descriptor.notifyReferencingDescriptorsOfIsolation(session);
        }
        if (this.getUnitOfWorkCacheIsolationLevel() == -1 || this.wasDefaultUnitOfWorkCacheIsolationLevel) {
            this.wasDefaultUnitOfWorkCacheIsolationLevel = true;
            if (this.isIsolated()) {
                this.setUnitOfWorkCacheIsolationLevel(4);
            } else if (this.isProtectedIsolation()) {
                this.setUnitOfWorkCacheIsolationLevel(3);
            } else {
                this.setUnitOfWorkCacheIsolationLevel(1);
            }
        }
        if (!this.isSharedIsolation()) {
            session.getProject().setHasIsolatedClasses(true);
        }
        if (!this.shouldIsolateObjectsInUnitOfWork() && !descriptor.shouldBeReadOnly()) {
            session.getProject().setHasNonIsolatedUOWClasses(true);
        }
    }

    public void initialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        if (this.hasCacheIndexes()) {
            for (CacheIndex index : this.getCacheIndexes().values()) {
                for (int count = 0; count < index.getFields().size(); ++count) {
                    index.getFields().set(count, descriptor.buildField(index.getFields().get(count)));
                }
            }
        }
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            ClassDescriptor referencedDescriptor;
            if (!mapping.isCacheable() && this.isSharedIsolation()) {
                this.setCacheIsolation(CacheIsolationType.PROTECTED);
            }
            if (mapping.isForeignReferenceMapping() && (referencedDescriptor = mapping.getReferenceDescriptor()) != null && this.isSharedIsolation() && !referencedDescriptor.getCachePolicy().isSharedIsolation()) {
                this.setCacheIsolation(CacheIsolationType.PROTECTED);
            }
            if (!mapping.isAggregateObjectMapping() || (referencedDescriptor = mapping.getReferenceDescriptor()) == null || !this.isSharedIsolation() || referencedDescriptor.getCachePolicy().isSharedIsolation()) continue;
            this.setCacheIsolation(CacheIsolationType.PROTECTED);
        }
        if (this.databaseChangeNotificationType == null) {
            this.databaseChangeNotificationType = DatabaseChangeNotificationType.INVALIDATE;
        }
        if (this.cacheSynchronizationType == 0) {
            this.cacheSynchronizationType = 1;
        }
        if (this.databaseChangeNotificationType != DatabaseChangeNotificationType.NONE && session.isDatabaseSession() && ((DatabaseSession)((Object)session)).getDatabaseEventListener() != null) {
            ((DatabaseSession)((Object)session)).getDatabaseEventListener().initialize(descriptor, session);
        }
    }

    public CacheIndex getCacheIndex(List<DatabaseField> fields) {
        return this.getCacheIndexes().get(fields);
    }

    public void addCacheIndex(CacheIndex index) {
        this.getCacheIndexes().put(index.getFields(), index);
    }

    public void addCacheIndex(String ... fields) {
        this.addCacheIndex(new CacheIndex(fields));
    }

    public void addCacheIndex(DatabaseField[] fields) {
        this.addCacheIndex(new CacheIndex(fields));
    }

    public boolean hasCacheIndexes() {
        return this.cacheIndexes != null && !this.cacheIndexes.isEmpty();
    }

    public Map<List<DatabaseField>, CacheIndex> getCacheIndexes() {
        if (this.cacheIndexes == null) {
            this.cacheIndexes = new HashMap<List<DatabaseField>, CacheIndex>();
        }
        return this.cacheIndexes;
    }

    public void setCacheIndexes(Map<List<DatabaseField>, CacheIndex> cacheIndexes) {
        this.cacheIndexes = cacheIndexes;
    }

    public CachePolicy clone() {
        try {
            return (CachePolicy)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.getMessage());
        }
    }

    public void assignDefaultValues(AbstractSession session) {
        if (this.identityMapSize == -1) {
            this.identityMapSize = session.getProject().getDefaultIdentityMapSize();
        }
        if (this.identityMapClass == null) {
            this.identityMapClass = session.getProject().getDefaultIdentityMapClass();
        }
        if (this.cacheIsolation == null) {
            this.cacheIsolation = session.getProject().getDefaultCacheIsolation();
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.cacheInterceptorClass == null && this.cacheInterceptorClassName != null) {
            this.cacheInterceptorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.cacheInterceptorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.cacheInterceptorClassName, ex));
        }
    }

    public boolean getFullyMergeEntity() {
        return this.fullyMergeEntity;
    }

    public void setCacheKeyType(CacheKeyType cacheKeyType) {
        this.cacheKeyType = cacheKeyType;
    }

    public CacheKeyType getCacheKeyType() {
        return this.cacheKeyType;
    }

    public <T extends CacheInterceptor> Class<T> getCacheInterceptorClass() {
        return this.cacheInterceptorClass;
    }

    public String getCacheInterceptorClassName() {
        return this.cacheInterceptorClassName;
    }

    public int getCacheSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public <T extends IdentityMap> Class<T> getIdentityMapClass() {
        return this.identityMapClass;
    }

    public int getIdentityMapSize() {
        return this.identityMapSize;
    }

    public <T extends IdentityMap> Class<T> getRemoteIdentityMapClass() {
        if (this.remoteIdentityMapClass == null) {
            this.remoteIdentityMapClass = this.getIdentityMapClass();
        }
        return this.remoteIdentityMapClass;
    }

    public int getRemoteIdentityMapSize() {
        if (this.remoteIdentityMapSize == -1) {
            this.remoteIdentityMapSize = this.getIdentityMapSize();
        }
        return this.remoteIdentityMapSize;
    }

    public boolean shouldDisableCacheHits() {
        return this.shouldDisableCacheHits;
    }

    public boolean shouldDisableCacheHitsOnRemote() {
        return this.shouldDisableCacheHitsOnRemote;
    }

    public boolean shouldOnlyRefreshCacheIfNewerVersion() {
        return this.shouldOnlyRefreshCacheIfNewerVersion;
    }

    public boolean shouldAlwaysRefreshCache() {
        return this.shouldAlwaysRefreshCache;
    }

    public boolean shouldAlwaysRefreshCacheOnRemote() {
        return this.shouldAlwaysRefreshCacheOnRemote;
    }

    public void setShouldDisableCacheHits(boolean shouldDisableCacheHits) {
        this.shouldDisableCacheHits = shouldDisableCacheHits;
    }

    public void setShouldDisableCacheHitsOnRemote(boolean shouldDisableCacheHitsOnRemote) {
        this.shouldDisableCacheHitsOnRemote = shouldDisableCacheHitsOnRemote;
    }

    public void setShouldOnlyRefreshCacheIfNewerVersion(boolean shouldOnlyRefreshCacheIfNewerVersion) {
        this.shouldOnlyRefreshCacheIfNewerVersion = shouldOnlyRefreshCacheIfNewerVersion;
    }

    public void setShouldAlwaysRefreshCache(boolean shouldAlwaysRefreshCache) {
        this.shouldAlwaysRefreshCache = shouldAlwaysRefreshCache;
    }

    public void setShouldAlwaysRefreshCacheOnRemote(boolean shouldAlwaysRefreshCacheOnRemote) {
        this.shouldAlwaysRefreshCacheOnRemote = shouldAlwaysRefreshCacheOnRemote;
    }

    public void setRemoteIdentityMapClass(Class<? extends IdentityMap> theIdentityMapClass) {
        this.remoteIdentityMapClass = theIdentityMapClass;
    }

    public void setRemoteIdentityMapSize(int identityMapSize) {
        this.remoteIdentityMapSize = identityMapSize;
    }

    public void setCacheable(Boolean cacheable) {
        this.cacheable = cacheable;
    }

    public CacheIsolationType getCacheIsolation() {
        return this.cacheIsolation;
    }

    public void setCacheIsolation(CacheIsolationType isolationType) {
        this.cacheIsolation = isolationType;
        if (CacheIsolationType.ISOLATED == isolationType) {
            this.cacheSynchronizationType = 4;
        }
    }

    public boolean shouldIsolateObjectsInUnitOfWork() {
        return this.unitOfWorkCacheIsolationLevel == 4;
    }

    public boolean shouldIsolateProtectedObjectsInUnitOfWork() {
        return this.unitOfWorkCacheIsolationLevel == 3;
    }

    public boolean shouldIsolateObjectsInUnitOfWorkEarlyTransaction() {
        return this.unitOfWorkCacheIsolationLevel == 2;
    }

    public boolean shouldUseSessionCacheInUnitOfWorkEarlyTransaction() {
        return this.unitOfWorkCacheIsolationLevel == 0;
    }

    public int getUnitOfWorkCacheIsolationLevel() {
        return this.unitOfWorkCacheIsolationLevel;
    }

    public void setUnitOfWorkCacheIsolationLevel(int unitOfWorkCacheIsolationLevel) {
        this.unitOfWorkCacheIsolationLevel = unitOfWorkCacheIsolationLevel;
    }

    public void setFullyMergeEntity(boolean fullyMergeEntity) {
        this.fullyMergeEntity = fullyMergeEntity;
    }

    public void setIdentityMapClass(Class<? extends IdentityMap> theIdentityMapClass) {
        this.identityMapClass = theIdentityMapClass;
    }

    public void setIdentityMapSize(int identityMapSize) {
        this.identityMapSize = identityMapSize;
    }

    public void setCacheSynchronizationType(int type) {
        if (!this.isIsolated()) {
            this.cacheSynchronizationType = type;
        }
    }

    public void setCacheCoordinationType(CacheCoordinationType type) {
        if (type == null) {
            this.setCacheSynchronizationType(0);
        } else if (type == CacheCoordinationType.SEND_OBJECT_CHANGES) {
            this.setCacheSynchronizationType(1);
        } else if (type == CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS) {
            this.setCacheSynchronizationType(2);
        } else if (type == CacheCoordinationType.SEND_NEW_OBJECTS_WITH_CHANGES) {
            this.setCacheSynchronizationType(3);
        } else if (type == CacheCoordinationType.NONE) {
            this.setCacheSynchronizationType(4);
        }
    }

    public void setCacheInterceptorClass(Class<? extends CacheInterceptor> cacheInterceptorClass) {
        this.cacheInterceptorClass = cacheInterceptorClass;
    }

    public void setCacheInterceptorClassName(String cacheInterceptorClassName) {
        this.cacheInterceptorClassName = cacheInterceptorClassName;
    }

    public boolean isIsolated() {
        return CacheIsolationType.ISOLATED == this.cacheIsolation;
    }

    public boolean isProtectedIsolation() {
        return CacheIsolationType.PROTECTED == this.cacheIsolation;
    }

    public boolean isSharedIsolation() {
        return this.cacheIsolation == null || CacheIsolationType.SHARED == this.cacheIsolation;
    }

    public void indexObjectInCache(CacheKey cacheKey, AbstractRecord databaseRow, Object domainObject, ClassDescriptor descriptor, AbstractSession session, boolean refresh) {
        if (!this.hasCacheIndexes()) {
            return;
        }
        for (CacheIndex index : this.cacheIndexes.values()) {
            if (refresh && !index.isUpdateable()) continue;
            List<DatabaseField> fields = index.getFields();
            int size = fields.size();
            Object[] values = new Object[size];
            for (int count = 0; count < size; ++count) {
                values[count] = databaseRow.get(fields.get(count));
            }
            CacheId indexValues = new CacheId(values);
            session.getIdentityMapAccessorInstance().putCacheKeyByIndex(index, indexValues, cacheKey, descriptor);
        }
    }

    public void indexObjectInCache(CacheKey cacheKey, Object object, ClassDescriptor descriptor, AbstractSession session, boolean refresh) {
        if (!this.hasCacheIndexes()) {
            return;
        }
        for (CacheIndex index : this.cacheIndexes.values()) {
            if (refresh && !index.isUpdateable()) continue;
            List<DatabaseField> fields = index.getFields();
            int size = fields.size();
            Object[] values = new Object[size];
            for (int count = 0; count < size; ++count) {
                values[count] = descriptor.getObjectBuilder().extractValueFromObjectForField(object, fields.get(count), session);
            }
            CacheId indexValues = new CacheId(values);
            session.getIdentityMapAccessorInstance().putCacheKeyByIndex(index, indexValues, cacheKey, descriptor);
        }
    }

    public void indexObjectInCache(ObjectChangeSet changeSet, Object object, ClassDescriptor descriptor, AbstractSession session) {
        if (!this.hasCacheIndexes()) {
            return;
        }
        for (CacheIndex index : this.cacheIndexes.values()) {
            if (changeSet != null && (!changeSet.isNew() || !index.isInsertable()) && (changeSet.isNew() || !index.isUpdateable())) continue;
            List<DatabaseField> fields = index.getFields();
            int size = fields.size();
            Object[] values = new Object[size];
            for (int count = 0; count < size; ++count) {
                values[count] = descriptor.getObjectBuilder().extractValueFromObjectForField(object, fields.get(count), session);
            }
            CacheId indexValues = new CacheId(values);
            CacheKey cacheKey = null;
            Object id = null;
            if (changeSet != null) {
                cacheKey = changeSet.getActiveCacheKey();
                if (cacheKey == null) {
                    id = changeSet.getId();
                }
            } else {
                id = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session);
            }
            if (cacheKey == null) {
                cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(id, descriptor.getJavaClass(), descriptor, true);
            }
            session.getIdentityMapAccessorInstance().putCacheKeyByIndex(index, indexValues, cacheKey, descriptor);
        }
    }

    public CacheKey checkCacheByIndex(Expression expression, AbstractRecord translationRow, ClassDescriptor descriptor, AbstractSession session) {
        if (!this.hasCacheIndexes()) {
            return null;
        }
        AbstractRecord record = descriptor.getObjectBuilder().extractRowFromExpression(expression, translationRow, session);
        if (record == null) {
            return null;
        }
        for (CacheIndex index : this.cacheIndexes.values()) {
            Object value;
            List<DatabaseField> fields = index.getFields();
            int size = fields.size();
            Object[] values = new Object[size];
            for (int count = 0; count < size && (value = record.get(fields.get(count))) != null; ++count) {
                values[count] = value;
            }
            CacheId indexValues = new CacheId(values);
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyByIndex(index, indexValues, true, descriptor);
            if (cacheKey == null) continue;
            return cacheKey;
        }
        return null;
    }

    public boolean isIndexableExpression(Expression expression, ClassDescriptor descriptor, AbstractSession session) {
        if (!this.hasCacheIndexes()) {
            return false;
        }
        for (CacheIndex index : this.cacheIndexes.values()) {
            int size;
            HashSet<DatabaseField> foundFields;
            List<DatabaseField> searchFields = index.getFields();
            boolean isValid = expression.extractFields(true, false, descriptor, searchFields, foundFields = new HashSet<DatabaseField>(size = searchFields.size()));
            if (!isValid || foundFields.size() != size) continue;
            return true;
        }
        return false;
    }

    public void useFullIdentityMap() {
        this.setIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useHardCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useSoftIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftIdentityMap_Class);
    }

    public void useNoIdentityMap() {
        this.setIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    public void setPrefetchCacheKeys(boolean prefetchCacheKeys) {
        this.prefetchCacheKeys = prefetchCacheKeys;
    }

    public boolean shouldPrefetchCacheKeys() {
        return this.prefetchCacheKeys;
    }
}

