/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.tools.schemaframework.CheckConstraint;

public class CheckConstraintMetadata
extends ORMetadata {
    private static final String CHK = "CHK_";
    private static final char FIELD_SEP = '_';
    private String m_name;
    private String m_constraint;
    private String m_options;

    public CheckConstraintMetadata() {
        super("<check-constraint>");
    }

    public CheckConstraintMetadata(MetadataAnnotation checkConstraint, MetadataAccessor accessor) {
        super(checkConstraint, accessor);
        this.m_name = checkConstraint.getAttributeString("name");
        this.m_constraint = checkConstraint.getAttributeString("constraint");
        this.m_options = checkConstraint.getAttributeString("options");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CheckConstraintMetadata) {
            CheckConstraintMetadata checkConstraint = (CheckConstraintMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, checkConstraint.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_constraint, checkConstraint.getConstraint())) {
                return false;
            }
            return this.valuesMatch(this.m_options, checkConstraint.getOptions());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_constraint != null ? this.m_constraint.hashCode() : 0);
        result = 31 * result + (this.m_options != null ? this.m_options.hashCode() : 0);
        return result;
    }

    public String getConstraint() {
        return this.m_constraint;
    }

    public String getName() {
        return this.m_name;
    }

    public String getOptions() {
        return this.m_options;
    }

    public boolean hasName() {
        return this.m_name != null && !this.m_name.isEmpty();
    }

    public void process(DatabaseTable table) {
        CheckConstraint checkConstraint = new CheckConstraint();
        checkConstraint.setName(this.processName(table));
        checkConstraint.setConstraint(this.getConstraint());
        checkConstraint.setOptions(this.getOptions());
        table.addCheckConstraint(checkConstraint);
    }

    private String processName(DatabaseTable table) {
        return this.hasName() ? this.m_name : CHK + table.getName() + "_" + (table.getCheckConstraints().size() + 1);
    }

    public void setConstraint(String columnNames) {
        this.m_constraint = columnNames;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptions(String options) {
        this.m_options = options;
    }
}

