/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.jboss.classfilewriter.ClassFactory;

final class DefaultClassFactory
implements ClassFactory {
    private static final String DEFINE_CLASS_METHOD_NAME = "defineClass";
    private static final MethodHandle defineClassWithoutDomainParam;
    private static final MethodHandle defineClassWithDomainParam;
    static final ClassFactory INSTANCE;

    private DefaultClassFactory() {
    }

    @Override
    public Class<?> defineClass(ClassLoader loader, String name, byte[] b, int off, int len, ProtectionDomain domain) throws ClassFormatError {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                int index = name.lastIndexOf(46);
                String packageName = index == -1 ? "" : name.substring(0, index);
                RuntimePermission permission = new RuntimePermission("defineClassInPackage." + packageName);
                sm.checkPermission(permission);
            }
            if (domain == null) {
                return defineClassWithoutDomainParam.invokeExact(loader, name, b, 0, b.length);
            }
            return defineClassWithDomainParam.invokeExact(loader, name, b, 0, b.length, domain);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MethodHandle[] defineClassMethods;
        try {
            final MethodHandles.Lookup LOOKUP = MethodHandles.privateLookupIn(ClassLoader.class, MethodHandles.lookup());
            defineClassMethods = AccessController.doPrivileged(new PrivilegedExceptionAction<MethodHandle[]>(){

                @Override
                public MethodHandle[] run() throws Exception {
                    MethodHandle defineClass1 = LOOKUP.findVirtual(ClassLoader.class, DefaultClassFactory.DEFINE_CLASS_METHOD_NAME, MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE));
                    MethodHandle defineClass2 = LOOKUP.findVirtual(ClassLoader.class, DefaultClassFactory.DEFINE_CLASS_METHOD_NAME, MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class));
                    return new MethodHandle[]{defineClass1, defineClass2};
                }
            });
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot initialize " + DefaultClassFactory.class.getName(), t);
        }
        defineClassWithoutDomainParam = defineClassMethods[0];
        defineClassWithDomainParam = defineClassMethods[1];
        INSTANCE = new DefaultClassFactory();
    }
}

