/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.util.ResponseUtil;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.web.valve.GlassFishValve;

final class StandardHostValve
extends ValveBase {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static final ClassLoader standardHostValveClassLoader = StandardHostValve.class.getClassLoader();
    private static final String info = "org.apache.catalina.core.StandardHostValve/1.0";
    private GlassFishValve errorReportValve;

    StandardHostValve() {
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        Context context = this.preInvoke(request, response);
        if (context == null) {
            return 2;
        }
        if (context.getPipeline().hasNonBasicValves() || context.hasCustomPipeline()) {
            context.getPipeline().invoke(request, response);
        } else {
            context.getPipeline().getBasic().invoke(request, response);
        }
        return 2;
    }

    @Override
    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        Context context = this.preInvoke(request, response);
        if (context == null) {
            return;
        }
        if (context.getPipeline().hasNonBasicValves() || context.hasCustomPipeline()) {
            context.getPipeline().invoke(request, response);
        } else {
            context.getPipeline().getBasic().invoke(request, response);
        }
        this.postInvoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        try {
            Context context;
            String initParam;
            HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
            response.setSuspended(false);
            Throwable t = (Throwable)hreq.getAttribute("jakarta.servlet.error.exception");
            if (t != null) {
                this.throwable(request, response, t);
            } else {
                this.status(request, response);
            }
            boolean isDefaultErrorPageEnabled = true;
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null && (initParam = wrapper.findInitParameter("org.glassfish.web.isDefaultErrorPageEnabled")) != null) {
                isDefaultErrorPageEnabled = Boolean.parseBoolean(initParam);
            }
            if (this.errorReportValve != null && response.isError() && isDefaultErrorPageEnabled) {
                this.errorReportValve.postInvoke(request, response);
            }
            if ((context = request.getContext()) != null) {
                context.fireRequestDestroyedEvent((ServletRequest)hreq);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(standardHostValveClassLoader);
        }
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable realError = throwable;
        if (realError instanceof ServletException && (realError = ((ServletException)realError).getRootCause()) == null) {
            realError = throwable;
        }
        if (realError instanceof ClientAbortException) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AS-WEB-CORE-00229", realError.getCause().getMessage());
            }
            return;
        }
        ErrorPage errorPage = StandardHostValve.findErrorPage(context, throwable);
        if (errorPage == null && realError != throwable) {
            errorPage = StandardHostValve.findErrorPage(context, realError);
        }
        if (errorPage != null) {
            this.dispatchToErrorPage(request, response, errorPage, throwable, realError, 0);
        } else if (context.getDefaultErrorPage() != null) {
            this.dispatchToErrorPage(request, response, context.getDefaultErrorPage(), throwable, realError, 0);
        } else {
            ServletResponse servletResponse = (ServletResponse)response;
            ((HttpServletResponse)servletResponse).setStatus(500);
            response.setError();
            this.status(request, response);
        }
    }

    protected void status(Request request, Response response) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        int statusCode = ((HttpResponse)response).getStatus();
        ErrorPage errorPage = context.findErrorPage(statusCode);
        if (errorPage != null) {
            File file2;
            File file;
            if (errorPage.getLocation() != null && !(file = new File(context.getDocBase(), errorPage.getLocation())).exists() && !(file2 = new File(errorPage.getLocation())).exists()) {
                log.log(Level.WARNING, "AS-WEB-CORE-00230", new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
            }
            this.setErrorPageContentType(response, errorPage.getLocation(), context);
            this.dispatchToErrorPage(request, response, errorPage, null, null, statusCode);
        } else if (statusCode >= 400 && statusCode < 600 && context.getDefaultErrorPage() != null) {
            this.dispatchToErrorPage(request, response, context.getDefaultErrorPage(), null, null, statusCode);
        } else {
            errorPage = ((StandardHost)this.getContainer()).findErrorPage(statusCode);
            if (errorPage != null) {
                File file2;
                File file;
                if (errorPage.getLocation() != null && !(file = new File(context.getDocBase(), errorPage.getLocation())).exists() && !(file2 = new File(errorPage.getLocation())).exists()) {
                    log.log(Level.WARNING, "AS-WEB-CORE-00230", new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
                }
                try {
                    this.setErrorPageContentType(response, errorPage.getLocation(), context);
                    this.handleHostErrorPage(response, errorPage, statusCode);
                }
                catch (Exception e) {
                    this.log("Exception processing " + String.valueOf(errorPage), e);
                }
            }
        }
    }

    protected static ErrorPage findErrorPage(Context context, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String name = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    protected boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.debug >= 1) {
            this.log("Processing " + String.valueOf(errorPage));
        }
        HttpResponse httpResponse = (HttpResponse)response;
        HttpRequest httpRequest = (HttpRequest)request;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        httpRequest.setPathInfo(errorPage.getLocation());
        try {
            httpResponse.setError((Integer)httpServletRequest.getAttribute("jakarta.servlet.error.status_code"), (String)httpServletRequest.getAttribute("jakarta.servlet.error.message"));
            ServletContext servletContext = request.getContext().getServletContext();
            ApplicationDispatcher dispatcher = (ApplicationDispatcher)servletContext.getRequestDispatcher(errorPage.getLocation());
            if (httpServletResponse.isCommitted()) {
                dispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                response.resetBuffer(true);
                dispatcher.dispatch((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, DispatcherType.ERROR);
                response.setSuspended(false);
            }
            return true;
        }
        catch (Throwable t) {
            this.log("Exception Processing " + String.valueOf(errorPage), t);
            return false;
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.toString() + ": " + message, t);
        }
    }

    private void handleHostErrorPage(Response response, ErrorPage errorPage, int statusCode) throws Exception {
        String message;
        ServletOutputStream outputStream = null;
        PrintWriter writer = null;
        FileReader reader = null;
        BufferedInputStream istream = null;
        IOException ioException = null;
        if (!response.getResponse().isCommitted()) {
            response.resetBuffer(true);
        }
        if ((message = errorPage.getReason()) != null) {
            ((HttpResponse)response).reset(statusCode, message);
        }
        try {
            outputStream = response.getResponse().getOutputStream();
        }
        catch (IllegalStateException e) {
            writer = response.getResponse().getWriter();
        }
        if (writer != null) {
            reader = new FileReader(errorPage.getLocation());
            ioException = ResponseUtil.copy(reader, writer);
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
        } else {
            istream = new BufferedInputStream(new FileInputStream(errorPage.getLocation()));
            ioException = ResponseUtil.copy(istream, outputStream);
            try {
                istream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    void setErrorReportValve(GlassFishValve errorReportValve) {
        this.errorReportValve = errorReportValve;
    }

    private Context preInvoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            ((HttpServletResponse)response.getResponse()).sendError(500);
            response.setDetailMessage(rb.getString("AS-WEB-CORE-00231"));
            return null;
        }
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        httpServletRequest.getSession(false);
        context.fireRequestInitializedEvent((ServletRequest)httpServletRequest);
        return context;
    }

    private void dispatchToErrorPage(Request request, Response response, ErrorPage errorPage, Throwable throwable, Throwable realError, int statusCode) {
        response.setAppCommitted(false);
        ServletRequest servletRequest = request.getRequest();
        ServletResponse servletResponse = response.getResponse();
        servletRequest.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)errorPage.getLocation());
        servletRequest.setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)servletRequest).getRequestURI());
        Wrapper wrapper = request.getWrapper();
        if (wrapper != null) {
            servletRequest.setAttribute("jakarta.servlet.error.servlet_name", (Object)wrapper.getName());
        }
        if (throwable != null) {
            servletRequest.setAttribute("jakarta.servlet.error.status_code", (Object)500);
            servletRequest.setAttribute("jakarta.servlet.error.message", (Object)throwable.getMessage());
            servletRequest.setAttribute("jakarta.servlet.error.exception", (Object)realError);
            servletRequest.setAttribute("jakarta.servlet.error.exception_type", realError.getClass());
        } else {
            servletRequest.setAttribute("jakarta.servlet.error.status_code", (Object)statusCode);
            String message = ((HttpResponse)response).getMessage();
            if (message == null) {
                message = "";
            }
            servletRequest.setAttribute("jakarta.servlet.error.message", (Object)message);
        }
        if (this.custom(request, response, errorPage)) {
            try {
                servletResponse.flushBuffer();
            }
            catch (IOException e) {
                this.log("Exception processing " + String.valueOf(errorPage), e);
            }
        }
    }

    private void setErrorPageContentType(Response response, String location, Context context) {
        if (response.getContentType() == null && location != null) {
            String contentType = location.substring(location.lastIndexOf(46) + 1);
            if ((contentType = context.findMimeMapping(contentType.toLowerCase(Locale.ENGLISH))) != null) {
                ((ServletResponse)response).setContentType(contentType);
            }
        }
    }
}

