/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.WebConnection;
import jakarta.websocket.server.ServerContainer;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.wsadl.model.Application;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.servlet.TyrusServletWriter;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

class TyrusServletUpgrade {
    private static final Logger LOGGER = Logger.getLogger(TyrusServletUpgrade.class.getName());
    private TyrusWebSocketEngine engine;
    private final boolean wsadlEnabled;
    private final Lock jaxbContextLock = new ReentrantLock();
    private final Map<HttpSession, TyrusHttpUpgradeHandler> sessionToHandler = new ConcurrentHashMap<HttpSession, TyrusHttpUpgradeHandler>();
    private TyrusServerContainer serverContainer = null;
    private JAXBContext wsadlJaxbContext;

    TyrusServletUpgrade(TyrusWebSocketEngine engine, boolean wsadlEnabled) {
        this.engine = engine;
        this.wsadlEnabled = wsadlEnabled;
    }

    void init(ServletContext servletContext) throws ServletException {
        this.serverContainer = (TyrusServerContainer)servletContext.getAttribute(ServerContainer.class.getName());
        try {
            this.serverContainer.start(servletContext.getContextPath(), 0);
        }
        catch (Exception e) {
            throw new ServletException("Web socket server initialization failed.", (Throwable)e);
        }
        finally {
            this.serverContainer.doneDeployment();
        }
    }

    boolean upgrade(final HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String header = httpServletRequest.getHeader("Sec-WebSocket-Key");
        if (header != null) {
            LOGGER.fine("Setting up WebSocket protocol handler");
            TyrusHttpUpgradeHandlerProxy handler = new TyrusHttpUpgradeHandlerProxy();
            Map paramMap = httpServletRequest.getParameterMap();
            TyrusServletWriter webSocketConnection = new TyrusServletWriter(handler);
            RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(httpServletRequest.getRequestURI())).queryString(httpServletRequest.getQueryString()).httpSession((Object)httpServletRequest.getSession(false)).secure(httpServletRequest.isSecure()).userPrincipal(httpServletRequest.getUserPrincipal()).isUserInRoleDelegate(new RequestContext.Builder.IsUserInRoleDelegate(){

                public boolean isUserInRole(String role) {
                    return httpServletRequest.isUserInRole(role);
                }
            }).parameterMap(paramMap).remoteAddr(httpServletRequest.getRemoteAddr()).serverAddr(httpServletRequest.getLocalName() == null ? httpServletRequest.getLocalAddr() : httpServletRequest.getLocalName()).serverPort(httpServletRequest.getLocalPort()).tyrusProperties(this.getInitParams(httpServletRequest.getServletContext())).build();
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration headerValues = httpServletRequest.getHeaders(name);
                while (headerValues.hasMoreElements()) {
                    List values = (List)requestContext.getHeaders().get(name);
                    if (values == null) {
                        requestContext.getHeaders().put(name, Utils.parseHeaderValue((String)((String)headerValues.nextElement()).trim()));
                        continue;
                    }
                    values.addAll(Utils.parseHeaderValue((String)((String)headerValues.nextElement()).trim()));
                }
            }
            TyrusUpgradeResponse tyrusUpgradeResponse = new TyrusUpgradeResponse();
            WebSocketEngine.UpgradeInfo upgradeInfo = this.engine.upgrade((UpgradeRequest)requestContext, (UpgradeResponse)tyrusUpgradeResponse);
            switch (upgradeInfo.getStatus()) {
                case HANDSHAKE_FAILED: {
                    TyrusServletUpgrade.appendAllHeaders(httpServletResponse, tyrusUpgradeResponse);
                    httpServletResponse.sendError(tyrusUpgradeResponse.getStatus());
                    break;
                }
                case NOT_APPLICABLE: {
                    TyrusServletUpgrade.appendTraceHeaders(httpServletResponse, tyrusUpgradeResponse);
                    return false;
                }
                case SUCCESS: {
                    LOGGER.fine("Upgrading Servlet request");
                    handler.setHandler((TyrusHttpUpgradeHandler)httpServletRequest.upgrade(TyrusHttpUpgradeHandler.class));
                    String frameBufferSize = httpServletRequest.getServletContext().getInitParameter("org.glassfish.tyrus.servlet.incoming-buffer-size");
                    if (frameBufferSize != null) {
                        handler.setIncomingBufferSize(Integer.parseInt(frameBufferSize));
                    }
                    handler.preInit(upgradeInfo, webSocketConnection, httpServletRequest.getUserPrincipal() != null);
                    if (requestContext.getHttpSession() != null) {
                        this.sessionToHandler.put((HttpSession)requestContext.getHttpSession(), handler);
                    }
                    httpServletResponse.setStatus(tyrusUpgradeResponse.getStatus());
                    TyrusServletUpgrade.appendAllHeaders(httpServletResponse, tyrusUpgradeResponse);
                    httpServletResponse.flushBuffer();
                    LOGGER.fine("Handshake Complete");
                }
            }
            return true;
        }
        if (this.wsadlEnabled && httpServletRequest.getMethod().equals("GET") && httpServletRequest.getRequestURI().endsWith("application.wsadl")) {
            try {
                this.getWsadlJaxbContext().createMarshaller().marshal((Object)this.engine.getWsadlApplication(), (java.io.Writer)httpServletResponse.getWriter());
            }
            catch (JAXBException e) {
                throw new ServletException((Throwable)e);
            }
            httpServletResponse.setStatus(200);
            httpServletResponse.setContentType("application/wsadl+xml");
            httpServletResponse.flushBuffer();
            return true;
        }
        return false;
    }

    TyrusHttpUpgradeHandler destroySession(HttpSession session) {
        TyrusHttpUpgradeHandler upgradeHandler = this.sessionToHandler.get(session);
        if (upgradeHandler != null) {
            this.sessionToHandler.remove(session);
            upgradeHandler.sessionDestroyed();
        }
        return upgradeHandler;
    }

    private static void appendTraceHeaders(HttpServletResponse httpServletResponse, TyrusUpgradeResponse tyrusUpgradeResponse) {
        for (Map.Entry entry : tyrusUpgradeResponse.getHeaders().entrySet()) {
            if (!((String)entry.getKey()).contains("X-Tyrus-Tracing-")) continue;
            httpServletResponse.addHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
    }

    private static void appendAllHeaders(HttpServletResponse httpServletResponse, TyrusUpgradeResponse tyrusUpgradeResponse) {
        for (Map.Entry entry : tyrusUpgradeResponse.getHeaders().entrySet()) {
            httpServletResponse.addHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
    }

    private JAXBContext getWsadlJaxbContext() throws JAXBException {
        this.jaxbContextLock.lock();
        try {
            if (this.wsadlJaxbContext == null) {
                this.wsadlJaxbContext = JAXBContext.newInstance((String)Application.class.getPackage().getName());
            }
            JAXBContext jAXBContext = this.wsadlJaxbContext;
            return jAXBContext;
        }
        finally {
            this.jaxbContextLock.unlock();
        }
    }

    private Map<String, Object> getInitParams(ServletContext ctx) {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        Enumeration enumeration = ctx.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String initName = (String)enumeration.nextElement();
            initParams.put(initName, ctx.getInitParameter(initName));
        }
        return initParams;
    }

    public void destroy() {
        this.sessionToHandler.forEach((session, upgradeHandler) -> upgradeHandler.destroy());
        this.sessionToHandler.clear();
        this.serverContainer.stop();
        this.engine.getApplicationEventListener().onApplicationDestroyed();
        this.serverContainer = null;
        this.engine = null;
    }

    private static class TyrusHttpUpgradeHandlerProxy
    extends TyrusHttpUpgradeHandler {
        private TyrusHttpUpgradeHandler handler;

        private TyrusHttpUpgradeHandlerProxy() {
        }

        @Override
        public void init(WebConnection wc) {
            this.handler.init(wc);
        }

        @Override
        public void onDataAvailable() {
            this.handler.onDataAvailable();
        }

        @Override
        public void onAllDataRead() {
            this.handler.onAllDataRead();
        }

        @Override
        public void onError(Throwable t) {
            this.handler.onError(t);
        }

        @Override
        public void destroy() {
            this.handler.destroy();
        }

        @Override
        public void sessionDestroyed() {
            this.handler.sessionDestroyed();
        }

        @Override
        public void preInit(WebSocketEngine.UpgradeInfo upgradeInfo, Writer writer, boolean authenticated) {
            this.handler.preInit(upgradeInfo, writer, authenticated);
        }

        @Override
        public void setIncomingBufferSize(int incomingBufferSize) {
            this.handler.setIncomingBufferSize(incomingBufferSize);
        }

        @Override
        WebConnection getWebConnection() {
            return this.handler.getWebConnection();
        }

        void setHandler(TyrusHttpUpgradeHandler handler) {
            this.handler = handler;
        }
    }
}

