/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util;

import java.util.regex.Pattern;

public class InputValidationUtil {
    public static final String CRLF_ENCODED_STRING_LOWER = "%0d%0a";
    public static final String CRLF_ENCODED_STRING_UPPER = "%0D%0A";
    public static final String CR_ENCODED_STRING_LOWER = "%0d";
    public static final String CR_ENCODED_STRING_UPPER = "%0D";
    public static final String CRLF_STRING = "\"\\r\\n\"";

    public static boolean validateStringforCRLF(String input) {
        return input != null && (input.contains(CRLF_ENCODED_STRING_LOWER) || input.contains(CRLF_ENCODED_STRING_UPPER) || input.contains(CR_ENCODED_STRING_UPPER) || input.contains(CR_ENCODED_STRING_LOWER) || input.contains(CRLF_STRING));
    }

    public static String removeLinearWhiteSpaces(String input) {
        if (input != null) {
            input = Pattern.compile("\\s").matcher(input).replaceAll(" ");
        }
        return input;
    }

    public static String getSafeHeaderName(String headerName) throws Exception {
        if (InputValidationUtil.validateStringforCRLF(headerName = InputValidationUtil.removeLinearWhiteSpaces(headerName))) {
            throw new Exception("Header Name invalid characters");
        }
        return headerName;
    }

    public static String getSafeHeaderValue(String headerValue) throws Exception {
        if (InputValidationUtil.validateStringforCRLF(headerValue = InputValidationUtil.removeLinearWhiteSpaces(headerValue))) {
            throw new Exception("Header Value invalid characters");
        }
        return headerValue;
    }

    public static String getSafeCookieHeaderValue(String headerValue) throws Exception {
        if (InputValidationUtil.validateStringforCRLF(headerValue = InputValidationUtil.removeLinearWhiteSpaces(headerValue))) {
            throw new Exception(" Cookie Header Value has invalid characters");
        }
        return headerValue;
    }
}

