/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;

class FieldUpdater
implements Constants {
    private long where;
    private MemberDefinition field;
    private Expression base;
    private MemberDefinition getter;
    private MemberDefinition setter;
    private int depth;

    public FieldUpdater(long where, MemberDefinition field, Expression base, MemberDefinition getter, MemberDefinition setter) {
        this.where = where;
        this.field = field;
        this.base = base;
        this.getter = getter;
        this.setter = setter;
    }

    public FieldUpdater inline(Environment env, Context ctx) {
        if (this.base != null) {
            this.base = this.field.isStatic() ? this.base.inline(env, ctx) : this.base.inlineValue(env, ctx);
        }
        return this;
    }

    public FieldUpdater copyInline(Context ctx) {
        return new FieldUpdater(this.where, this.field, this.base.copyInline(ctx), this.getter, this.setter);
    }

    public int costInline(int thresh, Environment env, Context ctx, boolean needGet) {
        int cost;
        int n = cost = needGet ? 7 : 3;
        if (!this.field.isStatic() && this.base != null) {
            cost += this.base.costInline(thresh, env, ctx);
        }
        return cost;
    }

    private void codeDup(Assembler asm, int items, int depth) {
        switch (items) {
            case 0: {
                return;
            }
            case 1: {
                switch (depth) {
                    case 0: {
                        asm.add(this.where, 89);
                        return;
                    }
                    case 1: {
                        asm.add(this.where, 90);
                        return;
                    }
                    case 2: {
                        asm.add(this.where, 91);
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (depth) {
                    case 0: {
                        asm.add(this.where, 92);
                        return;
                    }
                    case 1: {
                        asm.add(this.where, 93);
                        return;
                    }
                    case 2: {
                        asm.add(this.where, 94);
                        return;
                    }
                }
            }
        }
        throw new CompilerError("can't dup: " + items + ", " + depth);
    }

    public void startUpdate(Environment env, Context ctx, Assembler asm, boolean valNeeded) {
        if (!this.getter.isStatic() || !this.setter.isStatic()) {
            throw new CompilerError("startUpdate isStatic");
        }
        if (!this.field.isStatic()) {
            this.base.codeValue(env, ctx, asm);
            this.depth = 1;
        } else {
            if (this.base != null) {
                this.base.code(env, ctx, asm);
            }
            this.depth = 0;
        }
        this.codeDup(asm, this.depth, 0);
        asm.add(this.where, 184, this.getter);
        if (valNeeded) {
            this.codeDup(asm, this.field.getType().stackSize(), this.depth);
        }
    }

    public void finishUpdate(Environment env, Context ctx, Assembler asm, boolean valNeeded) {
        if (valNeeded) {
            this.codeDup(asm, this.field.getType().stackSize(), this.depth);
        }
        asm.add(this.where, 184, this.setter);
    }

    public void startAssign(Environment env, Context ctx, Assembler asm) {
        if (!this.setter.isStatic()) {
            throw new CompilerError("startAssign isStatic");
        }
        if (!this.field.isStatic()) {
            this.base.codeValue(env, ctx, asm);
            this.depth = 1;
        } else {
            if (this.base != null) {
                this.base.code(env, ctx, asm);
            }
            this.depth = 0;
        }
    }

    public void finishAssign(Environment env, Context ctx, Assembler asm, boolean valNeeded) {
        if (valNeeded) {
            this.codeDup(asm, this.field.getType().stackSize(), this.depth);
        }
        asm.add(this.where, 184, this.setter);
    }
}

