/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.logging.LogLevel;
import org.glassfish.gms.admin.GMSAnnounceSupplementalInfo;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.shoal.gms.api.core.GMSConstants;
import org.jvnet.hk2.annotations.Service;

@Service(name="_gms-announce-after-stop-cluster-command")
@Supplemental(value="stop-cluster", on=Supplemental.Timing.After, ifFailure=FailurePolicy.Warn)
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_gms-announce-after-stop-cluster-command", description="_gms-announce-after-stop-cluster-command")})
public class GMSAnnounceAfterStopClusterCommand
implements AdminCommand {
    @LoggerInfo(subsystem="CLSTR", description="Group Management Service Admin Logger", publish=true)
    private static final String GMS_LOGGER_NAME = "jakarta.enterprise.cluster.gms.admin";
    @LogMessagesResourceBundle
    private static final String LOG_MESSAGES_RB = "org.glassfish.cluster.gms.LogMessages";
    static final Logger GMS_LOGGER = Logger.getLogger("jakarta.enterprise.cluster.gms.admin", "org.glassfish.cluster.gms.LogMessages");
    @LogMessageInfo(message="An exception occurred while announcing GMS group shutdown: {0}", level="WARNING", cause="An unexpected exception occurred in the GMS implementation.", action="Check the server log file for more information from Shoal-GMS.")
    private static final String GMS_GROUP_STOP_EXCEPTION = "NCLS-CLSTR-30003";
    @Param(optional=false, primary=true)
    private String clusterName;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        GMSAnnounceAfterStopClusterCommand.announceGMSGroupStopComplete(this.clusterName, report);
    }

    public static void announceGMSGroupStopComplete(String clusterName, ActionReport report) {
        GMSAnnounceSupplementalInfo gmsInfo;
        if (report != null && (gmsInfo = (GMSAnnounceSupplementalInfo)report.getResultType(GMSAnnounceSupplementalInfo.class)) != null && gmsInfo.gmsInitiated) {
            GMSConstants.shutdownState groupShutdownState = GMSConstants.shutdownState.COMPLETED;
            try {
                if (gmsInfo.gms != null) {
                    gmsInfo.gms.announceGroupShutdown(clusterName, groupShutdownState);
                }
            }
            catch (Throwable t) {
                GMS_LOGGER.log(LogLevel.WARNING, GMS_GROUP_STOP_EXCEPTION, t.getLocalizedMessage());
            }
        }
    }
}

