/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;

public class PackageAccessor
extends MetadataAccessor {
    private boolean m_isPreProcessed = false;
    private boolean m_isProcessed = false;
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private TableGeneratorMetadata m_tableGenerator;

    public PackageAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataProject project) {
        super(annotation, cls, new MetadataDescriptor(cls), project);
    }

    @Override
    public String getName() {
        return this.getAccessibleObjectName();
    }

    public boolean isPreProcessed() {
        return this.m_isPreProcessed;
    }

    public void preProcess() {
        this.getAccessibleObject().getAnnotations().values().forEach(annotation -> {
            if (this.isAnnotationPresent("jakarta.persistence.SequenceGenerator")) {
                this.m_sequenceGenerator = new SequenceGeneratorMetadata(this.getAnnotation("jakarta.persistence.SequenceGenerator"), this);
            }
            if (this.isAnnotationPresent("jakarta.persistence.TableGenerator")) {
                this.m_tableGenerator = new TableGeneratorMetadata(this.getAnnotation("jakarta.persistence.TableGenerator"), this);
            }
        });
        this.m_isPreProcessed = true;
    }

    @Override
    protected MetadataAnnotation getAnnotation(String annotation) {
        return this.getAccessibleObject().getAnnotation(annotation);
    }

    @Override
    public boolean isAnnotationPresent(String annotation) {
        return this.getAccessibleObject().isAnnotationPresent(annotation);
    }

    @Override
    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    @Override
    public void process() {
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema(), this.getName());
        }
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema(), this.getName());
        }
        this.m_isProcessed = true;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PackageAccessor) {
            PackageAccessor accessor = (PackageAccessor)objectToCompare;
            return this.valuesMatch(this.getName(), accessor.getName());
        }
        return false;
    }
}

